/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.AuthenticatorBase;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class BasicAuthenticator
extends AuthenticatorBase
implements Authenticator {
    private String username;
    private String password;
    private String authHeader;

    protected BasicAuthenticator() {
    }

    protected BasicAuthenticator(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public BasicAuthenticator(String username, String password) {
        this.init(username, password);
    }

    @Deprecated
    public BasicAuthenticator(Map<String, String> config) {
        this.init(config.get("USERNAME"), config.get("PASSWORD"));
    }

    public static BasicAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().username(config.get("USERNAME")).password(config.get("PASSWORD")).build();
    }

    private void init(String username, String password) {
        this.username = username;
        this.password = password;
        this.validate();
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.username)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "password"));
        }
        if (CredentialUtils.hasBadStartOrEndChar(this.username)) {
            throw new IllegalArgumentException(String.format("The %s property is invalid. Please remove any surrounding {, }, or \" characters.", "username"));
        }
        if (CredentialUtils.hasBadStartOrEndChar(this.password)) {
            throw new IllegalArgumentException(String.format("The %s property is invalid. Please remove any surrounding {, }, or \" characters.", "password"));
        }
        this.authHeader = BasicAuthenticator.constructBasicAuthHeader(this.username, this.password);
    }

    @Override
    public String authenticationType() {
        return "basic";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void authenticate(Request.Builder builder) {
        builder.addHeader("Authorization", this.authHeader);
    }

    public static class Builder {
        private String username;
        private String password;

        public Builder() {
        }

        private Builder(BasicAuthenticator obj) {
            this.username = obj.username;
            this.password = obj.password;
        }

        public BasicAuthenticator build() {
            return new BasicAuthenticator(this);
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }
    }
}

