/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    private static final String RFC3339_FULL_DATE = "yyyy-MM-dd";
    private static final String RFC3339_DATE_TIME_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String RFC3339_DATE_TIME_PARSE = "yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX";
    private static final String RFC3339_DATE_TIME_PARSE_NOCOLON = "yyyy-MM-dd'T'HH:mm:ss[.SSS]X";
    private static final String UTC_DATE_TIME_NO_TZ = "yyyy-MM-dd'T'HH:mm:ss[.SSS]";
    private static final String ALCHEMY_DATE_TIME = "yyyyMMdd'T'HHmmss";
    private static final String DIALOG_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter rfc3339FullDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter rfc3339DateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter rfc3339DateTimeParse = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX");
    private static final DateTimeFormatter rfc3339DateTimeParseNoColon = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]X");
    private static final DateTimeFormatter utcDateTimeWithoutTZ = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter dialogDateTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter alchemyDateTime = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withZone(ZoneOffset.UTC);
    private static final List<DateTimeFormatter> dateTimeParsers = Arrays.asList(rfc3339DateTimeParse, rfc3339DateTimeParseNoColon, utcDateTimeWithoutTZ, dialogDateTime, alchemyDateTime);
    private static Pattern isJustNumber = Pattern.compile("^\\d+$");

    private DateUtils() {
    }

    public static String formatAsDate(Date d) {
        return rfc3339FullDateFormat.format(d.toInstant());
    }

    public static String formatAsDateTime(Date d) {
        return rfc3339DateTimeFormatter.format(d.toInstant());
    }

    public static Date parseAsDate(String s) {
        LocalDate ld = LocalDate.parse(s.trim());
        Instant instant = Instant.from(ld.atStartOfDay(ZoneId.of("UTC")));
        Date d = Date.from(instant);
        return d;
    }

    public static Date parseAsDateTime(String dateAsString) {
        for (DateTimeFormatter format : dateTimeParsers) {
            try {
                return DateUtils.parse(dateAsString, format);
            }
            catch (Throwable throwable) {
            }
        }
        try {
            return DateUtils.parseAsDate(dateAsString);
        }
        catch (Throwable throwable) {
            Matcher foundMatch = isJustNumber.matcher(dateAsString);
            if (foundMatch.find()) {
                Long timeAsLong = Long.parseLong(dateAsString);
                return new Date(timeAsLong);
            }
            throw new DateTimeException(String.format("Text '%s' could not be parsed as a date-time value.", dateAsString));
        }
    }

    private static Date parse(String s, DateTimeFormatter formatter) {
        TemporalAccessor ta = formatter.parse(s);
        return Date.from(Instant.from(ta));
    }
}

