/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import java.net.Proxy;
import okhttp3.Authenticator;

public class HttpConfigOptions {
    private boolean disableSslVerification;
    private Boolean enableGzipCompression;
    private Proxy proxy;
    private Authenticator proxyAuthenticator;
    private LoggingLevel loggingLevel;
    private com.ibm.cloud.sdk.core.security.Authenticator authenticator;
    private int defaultInterval = 0;
    private int maxRetries = 0;

    public boolean shouldDisableSslVerification() {
        return this.disableSslVerification;
    }

    public Boolean getGzipCompression() {
        return this.enableGzipCompression;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public com.ibm.cloud.sdk.core.security.Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getDefaultRetryInterval() {
        return this.defaultInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    private HttpConfigOptions(Builder builder) {
        this.disableSslVerification = builder.disableSslVerification;
        this.enableGzipCompression = builder.enableGzipCompression;
        this.proxy = builder.proxy;
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.loggingLevel = builder.loggingLevel;
        this.authenticator = builder.authenticator;
        this.defaultInterval = builder.defaultInterval;
        this.maxRetries = builder.maxRetries;
    }

    public static class Builder {
        private boolean disableSslVerification;
        private Boolean enableGzipCompression;
        private Proxy proxy;
        private Authenticator proxyAuthenticator;
        private LoggingLevel loggingLevel;
        private com.ibm.cloud.sdk.core.security.Authenticator authenticator;
        private int defaultInterval = 0;
        private int maxRetries = 0;

        public HttpConfigOptions build() {
            return new HttpConfigOptions(this);
        }

        public Builder disableSslVerification(boolean disableSslVerification) {
            this.disableSslVerification = disableSslVerification;
            return this;
        }

        public Builder enableGzipCompression(Boolean enableGzipCompression) {
            this.enableGzipCompression = enableGzipCompression;
            return this;
        }

        public Builder enableRateLimitRetry(com.ibm.cloud.sdk.core.security.Authenticator authenticator, int defaultInterval, int maxRetries) {
            this.authenticator = authenticator;
            this.defaultInterval = defaultInterval;
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder loggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }
    }

    public static enum LoggingLevel {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

