/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticatorImmutable;
import org.apache.commons.lang3.StringUtils;

public abstract class IamRequestBasedAuthenticatorImmutable
extends TokenRequestBasedAuthenticatorImmutable<IamToken, IamToken>
implements Authenticator {
    protected static final String DEFAULT_IAM_URL = "https://iam.cloud.ibm.com";
    protected String url;
    protected String scope;
    protected String clientId;
    protected String clientSecret;
    protected String cachedAuthorizationHeader = null;

    @Override
    public void validate() {
        if (!StringUtils.isEmpty((CharSequence)this.getClientId()) || !StringUtils.isEmpty((CharSequence)this.getClientSecret())) {
            if (StringUtils.isEmpty((CharSequence)this.getClientId())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientId"));
            }
            if (StringUtils.isEmpty((CharSequence)this.getClientSecret())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientSecret"));
            }
        }
        this.cachedAuthorizationHeader = IamRequestBasedAuthenticatorImmutable.constructBasicAuthHeader(this.clientId, this.clientSecret);
    }

    public String getURL() {
        return this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    protected void _setURL(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = DEFAULT_IAM_URL;
        }
        this.url = url;
    }

    protected void addAuthorizationHeader(RequestBuilder builder) {
        if (StringUtils.isNotEmpty((CharSequence)this.cachedAuthorizationHeader)) {
            builder.header("Authorization", this.cachedAuthorizationHeader);
        }
    }
}

