/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.MCSPToken;
import com.ibm.cloud.sdk.core.security.MCSPTokenResponse;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.net.Proxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MCSPAuthenticator
extends TokenRequestBasedAuthenticator<MCSPToken, MCSPTokenResponse>
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(MCSPAuthenticator.class.getName());
    private static final String OPERATION_PATH = "/siusermgr/api/1.0/apikeys/token";
    private String apikey;
    private String url;

    protected MCSPAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("mcsp-authenticator"));
    }

    protected MCSPAuthenticator(Builder builder) {
        this();
        this.apikey = builder.apikey;
        this.url = builder.url;
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static MCSPAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().apikey(config.get("APIKEY")).url(config.get("AUTH_URL")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.getURL())) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "url"));
        }
        if (StringUtils.isEmpty((CharSequence)this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "apikey"));
        }
    }

    @Override
    public String authenticationType() {
        return "mcsp";
    }

    public String getApiKey() {
        return this.apikey;
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public MCSPToken requestToken() {
        MCSPToken token;
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getURL(), OPERATION_PATH));
        builder.header("Accept", "application/json");
        builder.header("Content-Type", "application/json");
        builder.header("User-Agent", this.getUserAgent());
        String requestBody = String.format("{\"apikey\":\"%s\"}", this.getApiKey());
        builder.bodyContent(requestBody, "application/json");
        try {
            LOG.log(Level.FINE, "Invoking MCSP token service operation: POST {0}", builder.toUrl());
            MCSPTokenResponse response = this.invokeRequest(builder, MCSPTokenResponse.class);
            LOG.log(Level.FINE, "Returned from MCSP token service operation");
            token = new MCSPToken(response);
        }
        catch (Throwable t) {
            token = new MCSPToken(t);
            LOG.log(Level.FINE, "Exception from MCSP token service operation: ", t);
        }
        return token;
    }

    public static class Builder {
        private String apikey;
        private String url;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(MCSPAuthenticator obj) {
            this.apikey = obj.apikey;
            this.url = obj.getURL();
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public MCSPAuthenticator build() {
            return new MCSPAuthenticator(this);
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

