/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http.ratelimit;

import com.ibm.cloud.sdk.core.http.ratelimit.RateLimitContext;
import com.ibm.cloud.sdk.core.security.Authenticator;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

@Deprecated
public class RateLimitInterceptor
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(RateLimitInterceptor.class.getName());
    private int defaultInterval;
    private int maxRetries;
    private Authenticator authenticator;

    public RateLimitInterceptor(Authenticator authenticator, int defaultInterval, int maxRetries) {
        this.defaultInterval = defaultInterval;
        this.maxRetries = maxRetries;
        this.authenticator = authenticator;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        while (this.shouldRetry(response, request)) {
            int interval = this.getInterval(response);
            try {
                LOG.info("Will retry after: " + interval + "ms");
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                LOG.fine("Thread was interrupted, likely call cancelled");
            }
            Request.Builder builder = request.newBuilder();
            if (request.tag(RateLimitContext.class) == null) {
                builder = builder.tag(RateLimitContext.class, (Object)new RateLimitContext(this.maxRetries));
            }
            if (this.authenticator != null) {
                this.authenticator.authenticate(builder);
            }
            response.close();
            request = builder.build();
            response = chain.proceed(request);
        }
        return response;
    }

    private int getInterval(Response response) {
        int interval = this.defaultInterval;
        String headerVal = response.header("RateLimit-Reset");
        if (headerVal == null) {
            headerVal = response.header("Retry-After");
        }
        if (headerVal != null) {
            try {
                int responseInterval = Integer.parseInt(headerVal, 10) * 1000;
                if (responseInterval > 0) {
                    interval = responseInterval;
                }
            }
            catch (NumberFormatException e) {
                LOG.info("Response included a non-numeric value for Retry-After/RateLimit-Reset");
            }
        }
        return interval;
    }

    private boolean shouldRetry(Response response, Request request) {
        if (!response.isSuccessful() && response.code() == 429) {
            RateLimitContext context = (RateLimitContext)request.tag(RateLimitContext.class);
            if (context != null && !context.decrementAndCheck()) {
                LOG.info("Retries exhausted for RateLimit, giving up");
                return false;
            }
            if (context != null) {
                LOG.fine(context.toString());
            }
            return true;
        }
        return false;
    }
}

