/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.net.Proxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;

public class IamAuthenticator
extends IamRequestBasedAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(IamAuthenticator.class.getName());
    private static final String OPERATION_PATH = "/identity/token";
    private String apikey;

    protected IamAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("iam-authenticator"));
    }

    protected IamAuthenticator(Builder builder) {
        this();
        this.apikey = builder.apikey;
        this.setURL(builder.url);
        this.setScope(builder.scope);
        this.setClientIdAndSecret(builder.clientId, builder.clientSecret);
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public IamAuthenticator(String apikey) {
        this();
        this.init(apikey, null, null, null, false, null, null);
    }

    @Deprecated
    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers) {
        this();
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, null);
    }

    @Deprecated
    public IamAuthenticator(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this();
        this.init(apikey, url, clientId, clientSecret, disableSSLVerification, headers, scope);
    }

    @Deprecated
    public IamAuthenticator(Map<String, String> config) {
        this();
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty((CharSequence)apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        this.init(apikey, config.get("AUTH_URL"), config.get("CLIENT_ID"), config.get("CLIENT_SECRET"), Boolean.valueOf(config.get("AUTH_DISABLE_SSL")), null, config.get("SCOPE"));
    }

    public static IamAuthenticator fromConfiguration(Map<String, String> config) {
        String apikey = config.get("APIKEY");
        if (StringUtils.isEmpty((CharSequence)apikey)) {
            apikey = config.get("IAM_APIKEY");
        }
        return new Builder().apikey(apikey).url(config.get("AUTH_URL")).scope(config.get("SCOPE")).clientId(config.get("CLIENT_ID")).clientSecret(config.get("CLIENT_SECRET")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    protected void init(String apikey, String url, String clientId, String clientSecret, boolean disableSSLVerification, Map<String, String> headers, String scope) {
        this.apikey = apikey;
        this.setURL(url);
        this.setClientIdAndSecret(clientId, clientSecret);
        this.setScope(scope);
        this.validate();
        this.setDisableSSLVerification(disableSSLVerification);
        this.setHeaders(headers);
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isEmpty((CharSequence)this.getURL())) {
            this.setURL("https://iam.cloud.ibm.com");
        } else {
            this.setURL(StringUtils.removeEnd((String)this.getURL(), (String)OPERATION_PATH));
        }
        if (StringUtils.isEmpty((CharSequence)this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "apikey"));
        }
        if (CredentialUtils.hasBadStartOrEndChar(this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is invalid. Please remove any surrounding {, }, or \" characters.", "apikey"));
        }
    }

    @Override
    public String authenticationType() {
        return "iam";
    }

    public String getApiKey() {
        return this.apikey;
    }

    public String getUsername() {
        return this.getClientId();
    }

    public String getPassword() {
        return this.getClientSecret();
    }

    @Deprecated
    public void setBasicAuthInfo(String clientId, String clientSecret) {
        this.setClientIdAndSecret(clientId, clientSecret);
    }

    @Override
    public IamToken requestToken() {
        IamToken token;
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getURL(), OPERATION_PATH));
        builder.header("Accept", "application/json");
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        builder.header("User-Agent", this.getUserAgent());
        this.addAuthorizationHeader(builder);
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add("grant_type", "urn:ibm:params:oauth:grant-type:apikey").add("apikey", this.getApiKey()).add("response_type", "cloud_iam");
        if (!StringUtils.isEmpty((CharSequence)this.getScope())) {
            formBodyBuilder.add("scope", this.getScope());
        }
        FormBody formBody = formBodyBuilder.build();
        builder.body((RequestBody)formBody);
        try {
            LOG.log(Level.FINE, "Invoking IAM get_token operation: POST {0}", builder.toUrl());
            token = this.invokeRequest(builder, IamToken.class);
            LOG.log(Level.FINE, "Returned from IAM get_token operation");
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Exception from IAM get_token operation: ", t);
            token = new IamToken(t);
        }
        return token;
    }

    public static class Builder {
        private String apikey;
        private String url;
        private String scope;
        private String clientId;
        private String clientSecret;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(IamAuthenticator obj) {
            this.apikey = obj.apikey;
            this.url = obj.getURL();
            this.scope = obj.getScope();
            this.clientId = obj.getClientId();
            this.clientSecret = obj.getClientSecret();
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public IamAuthenticator build() {
            return new IamAuthenticator(this);
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

