/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.AuthenticatorBase;
import com.ibm.cloud.sdk.core.security.TokenServerResponse;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class TokenRequestBasedAuthenticator<T extends AbstractToken, R extends TokenServerResponse>
extends AuthenticatorBase
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(TokenRequestBasedAuthenticator.class.getName());
    protected OkHttpClient client;
    protected String userAgent;
    private boolean disableSSLVerification;
    private Map<String, String> headers;
    private Proxy proxy;
    private okhttp3.Authenticator proxyAuthenticator;
    private List<Object> cachedUserHeaders = null;
    protected T tokenData = null;

    private void setTokenData(T tokenData) {
        this.tokenData = tokenData;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected synchronized OkHttpClient getConfiguredClient() {
        if (this.client == null) {
            OkHttpClient defaultClient = HttpClientSingleton.getInstance().getHttpClient();
            HttpConfigOptions.Builder clientOptions = new HttpConfigOptions.Builder().disableSslVerification(this.disableSSLVerification).proxy(this.proxy).proxyAuthenticator(this.proxyAuthenticator);
            if (LOG.isLoggable(Level.FINE)) {
                clientOptions.loggingLevel(HttpConfigOptions.LoggingLevel.BODY);
            }
            this.client = HttpClientSingleton.getInstance().configureClient(defaultClient, clientOptions.build());
        }
        return this.client;
    }

    @Override
    public abstract void validate();

    @Override
    public abstract String authenticationType();

    public boolean getDisableSSLVerification() {
        return this.disableSSLVerification;
    }

    public void setDisableSSLVerification(boolean disableSSLVerification) {
        this.disableSSLVerification = disableSSLVerification;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        this.cachedUserHeaders = null;
        if (this.headers != null && !this.headers.isEmpty()) {
            this.cachedUserHeaders = new ArrayList<Object>();
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                this.cachedUserHeaders.add(header.getKey());
                this.cachedUserHeaders.add(header.getValue());
            }
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public okhttp3.Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public void setProxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
    }

    @Override
    public void authenticate(Request.Builder builder) {
        String headerValue = TokenRequestBasedAuthenticator.constructBearerTokenAuthHeader(this.getToken());
        if (headerValue != null) {
            builder.header("Authorization", headerValue);
            LOG.fine(String.format("Authenticated outbound request (type=%s)", this.authenticationType()));
        }
    }

    public abstract T requestToken();

    private synchronized T synchronizedRequestToken() {
        if (this.tokenData != null && ((AbstractToken)this.tokenData).isTokenValid()) {
            return this.tokenData;
        }
        return this.requestToken();
    }

    public String getToken() {
        if (this.tokenData == null || !((AbstractToken)this.tokenData).isTokenValid()) {
            LOG.fine("Performing synchronous token fetch...");
            this.setTokenData(this.synchronizedRequestToken());
        } else if (((AbstractToken)this.tokenData).needsRefresh()) {
            LOG.fine("Performing background asynchronous token fetch...");
            Thread updateTokenCall = new Thread(new Runnable(){

                @Override
                public void run() {
                    TokenRequestBasedAuthenticator.this.setTokenData(TokenRequestBasedAuthenticator.this.requestToken());
                }
            });
            updateTokenCall.start();
        } else {
            LOG.fine("Using cached access token...");
        }
        if (this.tokenData == null) {
            throw new RuntimeException("Error while fetching access token from token service:  illegal state: token object not available");
        }
        if (((AbstractToken)this.tokenData).getException() != null) {
            Throwable t = ((AbstractToken)this.tokenData).getException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Error while fetching access token from token service: ", ((AbstractToken)this.tokenData).getException());
        }
        String token = ((AbstractToken)this.tokenData).getAccessToken();
        return token;
    }

    protected R invokeRequest(RequestBuilder requestBuilder, final Class<? extends R> responseClass) throws Throwable {
        if (this.cachedUserHeaders != null && !this.cachedUserHeaders.isEmpty()) {
            requestBuilder.header(this.cachedUserHeaders.toArray());
        }
        final Object[] responseObj = new Object[1];
        final OkHttpClient client = this.getConfiguredClient();
        final Request request = requestBuilder.build();
        Thread restCall = new Thread(new Runnable(){

            @Override
            public void run() {
                Call call = client.newCall(request);
                ResponseConverter converter = ResponseConverterUtils.getObject((Type)responseClass);
                try {
                    Response response = call.execute();
                    if (response.code() >= 400) {
                        throw new ServiceResponseException(response.code(), response);
                    }
                    responseObj[0] = converter.convert(response);
                }
                catch (Throwable t) {
                    responseObj[0] = t;
                }
            }
        });
        restCall.start();
        try {
            restCall.join();
        }
        catch (Throwable t) {
            responseObj[0] = t;
        }
        if (responseObj[0] instanceof Throwable) {
            throw (Throwable)responseObj[0];
        }
        return (R)((TokenServerResponse)responseObj[0]);
    }
}

