/**
 * (C) Copyright IBM Corp. 2015, 2019.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.ibm.cloud.sdk.core.util;

import java.io.IOException;

import org.apache.commons.codec.binary.Base64;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * This class serves as a GSON type adapter for the "byte[]" type.
 * Values of type byte[] will be serialized into a string of base64-encoded characters.
 */
public class ByteArrayTypeAdapter extends TypeAdapter<byte[]> {

  @Override
  public void write(JsonWriter out, byte[] value) throws IOException {
    out.value(Base64.encodeBase64String(value));
  }

  @Override
  public byte[] read(JsonReader in) throws IOException {
    return Base64.decodeBase64(in.nextString());
  }
}
