/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.http.ServiceCallback;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.service.exception.BadRequestException;
import com.ibm.cloud.sdk.core.service.exception.ConflictException;
import com.ibm.cloud.sdk.core.service.exception.ForbiddenException;
import com.ibm.cloud.sdk.core.service.exception.InternalServerErrorException;
import com.ibm.cloud.sdk.core.service.exception.InvalidServiceResponseException;
import com.ibm.cloud.sdk.core.service.exception.NotAcceptableException;
import com.ibm.cloud.sdk.core.service.exception.NotFoundException;
import com.ibm.cloud.sdk.core.service.exception.RequestTooLargeException;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.service.exception.ServiceUnavailableException;
import com.ibm.cloud.sdk.core.service.exception.TooManyRequestsException;
import com.ibm.cloud.sdk.core.service.exception.UnauthorizedException;
import com.ibm.cloud.sdk.core.service.exception.UnsupportedException;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import io.reactivex.Single;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseService {
    public static final String PROPNAME_URL = "URL";
    public static final String PROPNAME_DISABLE_SSL = "DISABLE_SSL";
    public static final String PROPNAME_ENABLE_GZIP = "ENABLE_GZIP";
    public static final String PROPNAME_ENABLE_RETRIES = "ENABLE_RETRIES";
    public static final String PROPNAME_MAX_RETRIES = "MAX_RETRIES";
    public static final String PROPNAME_RETRY_INTERVAL = "RETRY_INTERVAL";
    private static final Logger LOG = Logger.getLogger(BaseService.class.getName());
    private static final String ERRORMSG_NO_AUTHENTICATOR = "Authentication information was not properly configured.";
    private static final String ERRORMSG_SSL = "The connection failed because the SSL certificate is not valid. To use a self-signed certificate, set the disableSslVerification parameter in HttpConfigOptions.";
    private String serviceUrl;
    private final String name;
    private Authenticator authenticator;
    private OkHttpClient client;
    private Headers defaultHeaders = null;
    protected static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/((json)|(merge\\-patch\\+json))(\\s*;.*)?");
    protected static final Pattern JSON_PATCH_MIME_PATTERN = Pattern.compile("(?i)application\\/json\\-patch\\+json(\\s*;.*)?");

    protected BaseService() {
        this.name = null;
    }

    public BaseService(String name, Authenticator authenticator) {
        this.name = name;
        if (authenticator == null) {
            throw new IllegalArgumentException(ERRORMSG_NO_AUTHENTICATOR);
        }
        this.authenticator = authenticator;
        this.client = this.configureHttpClient();
    }

    public void configureService(String serviceName) {
        Boolean enableRetries;
        String s;
        Boolean disableSSL;
        if (serviceName == null || serviceName.isEmpty()) {
            throw new IllegalArgumentException("Error configuring service. Service name is required.");
        }
        Map<String, String> props = CredentialUtils.getServiceProperties(serviceName);
        String url = props.get(PROPNAME_URL);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            this.setServiceUrl(url);
        }
        if ((disableSSL = Boolean.valueOf(props.get(PROPNAME_DISABLE_SSL))).booleanValue()) {
            HttpConfigOptions options = new HttpConfigOptions.Builder().disableSslVerification(true).build();
            this.configureClient(options);
        }
        if (StringUtils.isNotEmpty((CharSequence)(s = props.get(PROPNAME_ENABLE_GZIP)))) {
            Boolean enableGzipCompression = Boolean.valueOf(s);
            this.enableGzipCompression(enableGzipCompression);
        }
        if ((enableRetries = Boolean.valueOf(props.get(PROPNAME_ENABLE_RETRIES))).booleanValue()) {
            int maxRetries = 4;
            int maxRetryInterval = 30;
            try {
                maxRetries = Integer.valueOf(props.get(PROPNAME_MAX_RETRIES));
            }
            catch (NumberFormatException e) {
                LOG.warning("Non-numeric MAX_RETRIES value.");
            }
            try {
                maxRetryInterval = Integer.valueOf(props.get(PROPNAME_RETRY_INTERVAL));
            }
            catch (NumberFormatException e) {
                LOG.warning("Non-numeric RETRY_INTERVAL value.");
            }
            this.enableRetries(maxRetries, maxRetryInterval);
        }
    }

    public void enableGzipCompression(boolean shouldEnableCompression) {
        HttpConfigOptions options = new HttpConfigOptions.Builder().enableGzipCompression(shouldEnableCompression).build();
        this.configureClient(options);
    }

    public void enableRetries(int maxRetries, int maxRetryInterval) {
        HttpConfigOptions options = new HttpConfigOptions.Builder().enableRetries(this.authenticator, maxRetries, maxRetryInterval).build();
        this.configureClient(options);
    }

    public void disableRetries() {
        HttpConfigOptions options = new HttpConfigOptions.Builder().disableRetries().build();
        this.configureClient(options);
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && JSON_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static boolean isJsonPatchMimeType(String mimeType) {
        return mimeType != null && JSON_PATCH_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static String constructServiceUrl(String parameterizedUrl, Map<String, String> defaultUrlVariables, Map<String, String> providedUrlVariables) {
        if (providedUrlVariables == null) {
            providedUrlVariables = new HashMap<String, String>();
        }
        for (String name : providedUrlVariables.keySet()) {
            if (defaultUrlVariables.containsKey(name)) continue;
            throw new IllegalArgumentException(String.format("'%s' is an invalid variable name.\nValid variable names: %s.", name, defaultUrlVariables.keySet().stream().sorted().collect(Collectors.toList())));
        }
        String formattedUrl = parameterizedUrl;
        for (Map.Entry<String, String> defaultEntry : defaultUrlVariables.entrySet()) {
            String name = defaultEntry.getKey();
            String defaultValue = defaultEntry.getValue();
            String providedValue = providedUrlVariables.get(name);
            String formatValue = providedValue != null ? providedValue : defaultValue;
            formattedUrl = formattedUrl.replaceAll("\\{" + name + "}", formatValue);
        }
        return formattedUrl;
    }

    @Deprecated
    public static String constructServiceURL(String parameterizedUrl, Map<String, String> defaultUrlVariables, Map<String, String> providedUrlVariables) {
        return BaseService.constructServiceUrl(parameterizedUrl, defaultUrlVariables, providedUrlVariables);
    }

    protected OkHttpClient configureHttpClient() {
        return HttpClientSingleton.getInstance().createHttpClient();
    }

    public void configureClient(HttpConfigOptions options) {
        this.client = HttpClientSingleton.getInstance().configureClient(this.client, options);
    }

    private Call createCall(Request request) {
        Request.Builder builder = request.newBuilder();
        if (request.headers().get("User-Agent") == null) {
            this.setUserAgent(builder);
        }
        this.setDefaultHeaders(builder);
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        return this.client.newCall(newRequest);
    }

    private void setUserAgent(Request.Builder builder) {
        String userAgent = RequestUtils.getUserAgent();
        builder.header("User-Agent", userAgent);
    }

    protected void setDefaultHeaders(Request.Builder builder) {
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
        }
    }

    protected <T> ServiceCall<T> createServiceCall(Request request, ResponseConverter<T> converter) {
        Call call = this.createCall(request);
        return new IBMCloudSDKServiceCall<T>(call, converter);
    }

    public String getName() {
        return this.name;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.authenticator == null) {
            throw new IllegalArgumentException(ERRORMSG_NO_AUTHENTICATOR);
        }
        this.authenticator.authenticate(builder);
    }

    @Deprecated
    public String getEndPoint() {
        return this.getServiceUrl();
    }

    @Deprecated
    public void setEndPoint(String endPoint) {
        this.setServiceUrl(endPoint);
    }

    public Headers getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers == null ? null : Headers.of(headers);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setServiceUrl(String serviceUrl) {
        if (CredentialUtils.hasBadStartOrEndChar(serviceUrl)) {
            throw new IllegalArgumentException("The URL shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
        String newValue = serviceUrl;
        if (newValue != null && !newValue.isEmpty()) {
            newValue = newValue.endsWith("/") ? newValue.substring(0, newValue.length() - 1) : newValue;
        }
        this.serviceUrl = newValue;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append(" [");
        builder.append("serviceUrl=").append(this.serviceUrl != null ? this.serviceUrl : "<null>");
        return builder.append(']').toString();
    }

    protected <T> T processServiceCall(ResponseConverter<T> converter, okhttp3.Response response) {
        if (response.isSuccessful()) {
            try {
                return converter.convert(response);
            }
            catch (Throwable t) {
                throw new InvalidServiceResponseException(response, "Error processing the HTTP response", t);
            }
        }
        switch (response.code()) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new UnauthorizedException(response);
            }
            case 403: {
                throw new ForbiddenException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 406: {
                throw new NotAcceptableException(response);
            }
            case 409: {
                throw new ConflictException(response);
            }
            case 413: {
                throw new RequestTooLargeException(response);
            }
            case 415: {
                throw new UnsupportedException(response);
            }
            case 429: {
                throw new TooManyRequestsException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        throw new ServiceResponseException(response.code(), response);
    }

    class IBMCloudSDKServiceCall<T>
    implements ServiceCall<T> {
        private Call call;
        private ResponseConverter<T> converter;

        IBMCloudSDKServiceCall(Call call, ResponseConverter<T> converter) {
            this.call = call;
            this.converter = converter;
        }

        @Override
        public ServiceCall<T> addHeader(String name, String value) {
            Request.Builder builder = this.call.request().newBuilder();
            builder.header(name, value);
            this.call = BaseService.this.client.newCall(builder.build());
            return this;
        }

        @Override
        public Response<T> execute() {
            try {
                okhttp3.Response response = this.call.execute();
                T responseModel = BaseService.this.processServiceCall(this.converter, response);
                return new Response<T>(responseModel, response);
            }
            catch (IOException e) {
                if (e instanceof SSLHandshakeException) {
                    LOG.warning(BaseService.ERRORMSG_SSL);
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public void enqueue(final ServiceCallback<T> callback) {
            this.call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (e instanceof SSLHandshakeException) {
                        LOG.warning(BaseService.ERRORMSG_SSL);
                    }
                    callback.onFailure(e);
                }

                public void onResponse(Call call, okhttp3.Response response) {
                    try {
                        Object responseModel = BaseService.this.processServiceCall(IBMCloudSDKServiceCall.this.converter, response);
                        callback.onResponse(new Response(responseModel, response));
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                }
            });
        }

        @Override
        public Single<Response<T>> reactiveRequest() {
            return Single.fromCallable((Callable)new Callable<Response<T>>(){

                @Override
                public Response<T> call() {
                    try {
                        okhttp3.Response response = IBMCloudSDKServiceCall.this.call.execute();
                        Object responseModel = BaseService.this.processServiceCall(IBMCloudSDKServiceCall.this.converter, response);
                        return new Response(responseModel, response);
                    }
                    catch (IOException e) {
                        if (e instanceof SSLHandshakeException) {
                            LOG.warning(BaseService.ERRORMSG_SSL);
                        }
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        @Override
        public void cancel() {
            this.call.cancel();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.call.isExecuted()) {
                Request r = this.call.request();
                LOG.warning(r.method() + " request to " + r.url() + " has not been sent. Did you forget to call execute()?");
            }
        }
    }
}

