/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import com.ibm.cloud.sdk.core.http.IRetryInterceptor;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.util.DateUtils;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class RetryInterceptor
implements IRetryInterceptor {
    private static final Logger LOG = Logger.getLogger(RetryInterceptor.class.getName());
    private static final int DEFAULT_RETRY_INTERVAL = 1000;
    private Authenticator authenticator;
    private int maxRetries;
    private int maxRetryInterval;

    protected RetryInterceptor() {
    }

    public RetryInterceptor(int maxRetries, int maxRetryInterval, Authenticator authenticator) {
        this.authenticator = authenticator;
        this.maxRetries = maxRetries;
        this.maxRetryInterval = maxRetryInterval * 1000;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        while (this.shouldRetry(response, request)) {
            int interval = this.getInterval(response, request);
            try {
                LOG.fine("Will retry after: " + interval + "ms");
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                LOG.fine("Thread was interrupted, likely the call has been cancelled.");
            }
            Request.Builder builder = request.newBuilder();
            if (request.tag(RetryContext.class) == null) {
                builder.tag(RetryContext.class, (Object)new RetryContext());
            }
            if (this.authenticator != null) {
                this.authenticator.authenticate(builder);
            }
            response.close();
            request = builder.build();
            response = chain.proceed(request);
        }
        return response;
    }

    protected int getInterval(Response response, Request request) {
        Integer interval = null;
        String headerVal = response.header("Retry-After");
        if (StringUtils.isNotEmpty((CharSequence)headerVal)) {
            int responseInterval = 0;
            try {
                responseInterval = Integer.parseInt(headerVal, 10) * 1000;
            }
            catch (NumberFormatException e) {
                try {
                    Date retryTime = DateUtils.parseAsDateTime(headerVal);
                    responseInterval = (int)Instant.now().until(retryTime.toInstant(), ChronoUnit.MILLIS);
                }
                catch (DateTimeException dte) {
                    LOG.warning("Response included a non numberic and non HTTP Date value for Retry-After: " + headerVal);
                }
            }
            if (responseInterval > 0) {
                interval = responseInterval;
            }
        }
        if (interval == null) {
            RetryContext context = (RetryContext)request.tag(RetryContext.class);
            interval = context != null ? Integer.valueOf(this.calculateBackoff(context.getRetryCount())) : Integer.valueOf(this.calculateBackoff(0));
        }
        return interval;
    }

    protected boolean shouldRetry(Response response, Request request) {
        if (response.code() == 429 || response.code() >= 500 && response.code() != 501) {
            RetryContext context = (RetryContext)request.tag(RetryContext.class);
            return context == null || context.incCountAndCheck();
        }
        return false;
    }

    protected int calculateBackoff(int retryCount) {
        double newInterval = Math.pow(2.0, retryCount) * 1000.0;
        if (newInterval > (double)this.maxRetryInterval) {
            return this.maxRetryInterval;
        }
        return (int)newInterval;
    }

    public class RetryContext {
        private int retryCount;

        private RetryContext() {
        }

        private int getRetryCount() {
            return this.retryCount;
        }

        private boolean incCountAndCheck() {
            ++this.retryCount;
            return this.retryCount < RetryInterceptor.this.maxRetries;
        }
    }
}

