/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.TypeAdapters;
import com.ibm.cloud.sdk.core.util.ByteArrayTypeAdapter;
import com.ibm.cloud.sdk.core.util.DateDeserializer;
import com.ibm.cloud.sdk.core.util.DateSerializer;
import com.ibm.cloud.sdk.core.util.DiscriminatorBasedTypeAdapterFactory;
import com.ibm.cloud.sdk.core.util.DynamicModelTypeAdapterFactory;
import java.util.Date;

public final class GsonSingleton {
    private static Gson gson;
    private static Gson gsonWithoutPrinting;

    private GsonSingleton() {
    }

    private static Gson createGson(boolean prettyPrint, boolean serializeNulls) {
        GsonBuilder builder = new GsonBuilder();
        GsonSingleton.registerTypeAdapters(builder);
        if (prettyPrint) {
            builder.setPrettyPrinting();
        }
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.disableHtmlEscaping();
        return builder.create();
    }

    private static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        builder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        builder.registerTypeAdapter(byte[].class, (Object)new ByteArrayTypeAdapter());
        builder.registerTypeAdapter(LazilyParsedNumber.class, (Object)TypeAdapters.NUMBER);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new DynamicModelTypeAdapterFactory());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new DiscriminatorBasedTypeAdapterFactory());
    }

    public static synchronized Gson getGson() {
        if (gson == null) {
            gson = GsonSingleton.createGson(true, false);
        }
        return gson;
    }

    public static synchronized Gson getGsonWithoutPrettyPrinting() {
        if (gsonWithoutPrinting == null) {
            gsonWithoutPrinting = GsonSingleton.createGson(false, false);
        }
        return gsonWithoutPrinting;
    }

    public static Gson getGsonWithSerializeNulls() {
        return GsonSingleton.createGson(false, true);
    }
}

