/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.Cp4dTokenResponse;
import com.ibm.cloud.sdk.core.security.JsonWebToken;
import org.apache.commons.lang3.StringUtils;

public class Cp4dToken
extends AbstractToken {
    public String accessToken;
    public long expirationTimeInMillis;

    public Cp4dToken(String accessToken) {
        this.accessToken = accessToken;
        this.expirationTimeInMillis = -1L;
    }

    public Cp4dToken(Cp4dTokenResponse response) {
        this.accessToken = response.getAccessToken();
        JsonWebToken jwt = new JsonWebToken(this.accessToken);
        Long iat = jwt.getPayload().getIssuedAt();
        Long exp = jwt.getPayload().getExpiresAt();
        if (iat == null || exp == null) {
            throw new RuntimeException("Properties 'iat' and 'exp' MUST be present within the encoded access token");
        }
        long ttl = exp - iat;
        this.expirationTimeInMillis = (iat + (long)(0.8 * (double)ttl)) * 1000L;
    }

    @Override
    public boolean isTokenValid() {
        return StringUtils.isNotEmpty((CharSequence)this.accessToken) && (this.expirationTimeInMillis < 0L || System.currentTimeMillis() <= this.expirationTimeInMillis);
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }
}

