/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.cloud.sdk.core.util.EnvironmentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class CredentialUtils {
    private static final Logger log = Logger.getLogger(CredentialUtils.class.getName());
    public static final String PLAN_STANDARD = "standard";
    private static final String DEFAULT_CREDENTIAL_FILE_NAME = "ibm-credentials.env";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final String CREDENTIALS = "credentials";
    private static final String PLAN = "plan";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String URL = "url";
    private static final String IAM_APIKEY = "iam_apikey";
    private static final String APIKEY = "apikey";
    private static final String IAM_URL = "iam_url";

    private CredentialUtils() {
    }

    public static Map<String, String> getServiceProperties(String serviceName) {
        Map<String, String> props = CredentialUtils.getFileCredentialsAsMap(serviceName);
        if (props.isEmpty()) {
            props = CredentialUtils.getEnvCredentialsAsMap(serviceName);
        }
        if (props.isEmpty()) {
            props = CredentialUtils.getVcapCredentialsAsMap(serviceName);
        }
        return props;
    }

    public static boolean hasBadStartOrEndChar(String credentialValue) {
        return credentialValue != null && (credentialValue.startsWith("{") || credentialValue.startsWith("\"") || credentialValue.endsWith("}") || credentialValue.endsWith("\""));
    }

    private static JsonObject getVcapServices() {
        String envServices = EnvironmentUtils.getenv(VCAP_SERVICES);
        if (envServices == null) {
            return null;
        }
        JsonObject vcapServices = null;
        try {
            JsonParser parser = new JsonParser();
            vcapServices = (JsonObject)parser.parse(envServices);
        }
        catch (JsonSyntaxException e) {
            log.log(Level.INFO, "Error parsing VCAP_SERVICES", e);
        }
        return vcapServices;
    }

    private static JsonObject getCredentialsObject(JsonObject vcapServices, String serviceName, String plan) {
        for (Map.Entry entry : vcapServices.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(serviceName)) continue;
            JsonArray servInstances = vcapServices.getAsJsonArray(key);
            for (JsonElement instance : servInstances) {
                JsonObject service = instance.getAsJsonObject();
                String instancePlan = service.get(PLAN).getAsString();
                if (plan != null && !plan.equalsIgnoreCase(instancePlan)) continue;
                return instance.getAsJsonObject().getAsJsonObject(CREDENTIALS);
            }
        }
        return null;
    }

    public static String getVcapValue(String serviceName, String key) {
        return CredentialUtils.getVcapValue(serviceName, key, null);
    }

    public static String getVcapValue(String serviceName, String key, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVcapServices();
        if (services == null) {
            return null;
        }
        JsonObject jsonCredentials = CredentialUtils.getCredentialsObject(services, serviceName, plan);
        if (jsonCredentials != null && jsonCredentials.has(key)) {
            return jsonCredentials.get(key).getAsString();
        }
        return null;
    }

    private static List<File> getFilesToCheck() {
        ArrayList<File> files = new ArrayList<File>();
        String userSpecifiedPath = EnvironmentUtils.getenv("IBM_CREDENTIALS_FILE");
        String unixHomeDirectory = EnvironmentUtils.getenv("HOME");
        String windowsFirstHomeDirectory = EnvironmentUtils.getenv("HOMEDRIVE") + EnvironmentUtils.getenv("HOMEPATH");
        String windowsSecondHomeDirectory = EnvironmentUtils.getenv("USERPROFILE");
        String projectDirectory = System.getProperty("user.dir");
        if (StringUtils.isNotEmpty((CharSequence)userSpecifiedPath)) {
            files.add(new File(userSpecifiedPath));
        }
        if (StringUtils.isNotEmpty((CharSequence)unixHomeDirectory)) {
            files.add(new File(String.format("%s/%s", unixHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        }
        if (StringUtils.isNotEmpty((CharSequence)windowsFirstHomeDirectory) && !"nullnull".equals(windowsFirstHomeDirectory)) {
            files.add(new File(String.format("%s/%s", windowsFirstHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        }
        if (StringUtils.isNotEmpty((CharSequence)windowsSecondHomeDirectory)) {
            files.add(new File(String.format("%s/%s", windowsSecondHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        }
        if (StringUtils.isNotEmpty((CharSequence)projectDirectory)) {
            files.add(new File(String.format("%s/%s", projectDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        }
        return files;
    }

    private static List<String> getFirstExistingFileContents(List<File> files) {
        List credentialFileContents = null;
        try {
            for (File file : files) {
                if (!file.isFile()) continue;
                credentialFileContents = IOUtils.readLines((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
                break;
            }
        }
        catch (IOException e) {
            log.severe("There was a problem trying to read the credential file: " + e);
        }
        return credentialFileContents;
    }

    static Map<String, String> getFileCredentialsAsMap(String serviceName) {
        List<File> files = CredentialUtils.getFilesToCheck();
        List<String> contents = CredentialUtils.getFirstExistingFileContents(files);
        if (contents != null && !contents.isEmpty()) {
            return CredentialUtils.parseCredentials(serviceName, contents);
        }
        return Collections.emptyMap();
    }

    static Map<String, String> getEnvCredentialsAsMap(String serviceName) {
        Map<String, String> env = EnvironmentUtils.getenv();
        if (env != null && !env.isEmpty()) {
            HashMap<String, String> props = new HashMap<String, String>();
            serviceName = serviceName.toUpperCase().replaceAll("-", "_") + "_";
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String credentialName;
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.startsWith(serviceName) || !StringUtils.isNotEmpty((CharSequence)(credentialName = key.substring(serviceName.length()))) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                props.put(credentialName, value);
            }
            return props;
        }
        return Collections.emptyMap();
    }

    static Map<String, String> getVcapCredentialsAsMap(String serviceName) {
        HashMap<String, String> props = new HashMap<String, String>();
        CredentialUtils.addToMap(props, "USERNAME", CredentialUtils.getVcapValue(serviceName, USERNAME));
        CredentialUtils.addToMap(props, "PASSWORD", CredentialUtils.getVcapValue(serviceName, PASSWORD));
        CredentialUtils.addToMap(props, "URL", CredentialUtils.getVcapValue(serviceName, URL));
        CredentialUtils.addToMap(props, "AUTH_URL", CredentialUtils.getVcapValue(serviceName, IAM_URL));
        CredentialUtils.addToMap(props, "APIKEY", CredentialUtils.getVcapValue(serviceName, IAM_APIKEY));
        CredentialUtils.addToMap(props, "APIKEY", CredentialUtils.getVcapValue(serviceName, APIKEY));
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)props.get("APIKEY")))) {
            CredentialUtils.addToMap(props, "AUTH_TYPE", "iam");
        } else if (StringUtils.isNotEmpty((CharSequence)((CharSequence)props.get("USERNAME"))) || StringUtils.isNotEmpty((CharSequence)((CharSequence)props.get("PASSWORD")))) {
            CredentialUtils.addToMap(props, "AUTH_TYPE", "basic");
        }
        return props;
    }

    private static void addToMap(Map<String, String> map, String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            map.put(key, value);
        }
    }

    private static Map<String, String> parseCredentials(String serviceName, List<String> contents) {
        HashMap<String, String> props = new HashMap<String, String>();
        serviceName = serviceName.toUpperCase().replaceAll("-", "_") + "_";
        for (String line : contents) {
            String credentialName;
            String[] lineTokens;
            if (line.startsWith("#") || line.trim().isEmpty() || (lineTokens = line.split("=")).length != 2) continue;
            String key = lineTokens[0];
            String value = lineTokens[1];
            if (!key.startsWith(serviceName) || !StringUtils.isNotEmpty((CharSequence)(credentialName = key.substring(serviceName.length()))) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
            props.put(credentialName, value);
        }
        return props;
    }
}

