/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.BearerTokenAuthenticator;
import com.ibm.cloud.sdk.core.security.CloudPakForDataAuthenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.security.NoauthAuthenticator;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigBasedAuthenticatorFactory {
    protected ConfigBasedAuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(String serviceName) {
        Authenticator authenticator = null;
        Map<String, String> authProps = CredentialUtils.getFileCredentialsAsMap(serviceName);
        if (authProps.isEmpty()) {
            authProps = CredentialUtils.getEnvCredentialsAsMap(serviceName);
        }
        if (authProps.isEmpty()) {
            authProps = CredentialUtils.getVcapCredentialsAsMap(serviceName);
        }
        if (!authProps.isEmpty()) {
            authenticator = ConfigBasedAuthenticatorFactory.createAuthenticator(authProps);
        }
        return authenticator;
    }

    private static Authenticator createAuthenticator(Map<String, String> props) {
        Authenticator authenticator = null;
        String authType = props.get("AUTH_TYPE");
        if (StringUtils.isEmpty((CharSequence)authType)) {
            authType = "iam";
        }
        switch (authType) {
            case "noauth": {
                authenticator = new NoauthAuthenticator(props);
                break;
            }
            case "basic": {
                authenticator = new BasicAuthenticator(props);
                break;
            }
            case "iam": {
                authenticator = new IamAuthenticator(props);
                break;
            }
            case "cp4d": {
                authenticator = new CloudPakForDataAuthenticator(props);
                break;
            }
            case "bearerToken": {
                authenticator = new BearerTokenAuthenticator(props);
                break;
            }
        }
        return authenticator;
    }
}

