/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.exception;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.Headers;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseUtils;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.Response;

public class ServiceResponseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String ERRORS_KEY = "errors";
    private static final String MESSAGE_STRING = "message";
    private static final String ERROR_STRING = "error";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final Type debuggingInfoType = new TypeToken<Map<String, Object>>(){}.getType();
    private final int statusCode;
    private String message;
    private Headers headers;
    private Map<String, Object> debuggingInfo;

    public ServiceResponseException(int statusCode, Response response) {
        this.statusCode = statusCode;
        this.headers = new Headers(response.headers());
        String responseString = ResponseUtils.getString(response);
        try {
            JsonObject jsonObject = ResponseUtils.getJsonObject(responseString);
            if (jsonObject.has(ERRORS_KEY)) {
                this.message = jsonObject.remove(ERRORS_KEY).getAsJsonArray().get(0).getAsJsonObject().remove(MESSAGE_STRING).getAsString();
            } else if (jsonObject.has(ERROR_STRING)) {
                this.message = jsonObject.remove(ERROR_STRING).getAsString();
            } else if (jsonObject.has(MESSAGE_STRING)) {
                this.message = jsonObject.remove(MESSAGE_STRING).getAsString();
            } else if (jsonObject.has(ERROR_MESSAGE)) {
                this.message = jsonObject.remove(ERROR_MESSAGE).getAsString();
            }
            this.debuggingInfo = (Map)GsonSingleton.getGson().fromJson((JsonElement)jsonObject, debuggingInfoType);
        }
        catch (Exception e) {
            this.message = responseString;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getDebuggingInfo() {
        return this.debuggingInfo;
    }
}

