/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security.basicauth;

import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import com.ibm.cloud.sdk.core.util.CredentialUtils;

public class BasicAuthConfig
implements AuthenticatorConfig {
    private String username;
    private String password;

    @Override
    public String authenticationType() {
        return "basic";
    }

    @Override
    public void validate() {
        if (CredentialUtils.hasBadStartOrEndChar(this.username) || CredentialUtils.hasBadStartOrEndChar(this.password)) {
            throw new IllegalArgumentException("The username and password shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private BasicAuthConfig(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public static class Builder {
        private String username;
        private String password;

        public BasicAuthConfig build() {
            BasicAuthConfig config = new BasicAuthConfig(this);
            config.validate();
            return config;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }
    }
}

