/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import com.ibm.cloud.sdk.core.security.basicauth.BasicAuthConfig;
import com.ibm.cloud.sdk.core.security.basicauth.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.icp4d.ICP4DAuthenticator;
import com.ibm.cloud.sdk.core.security.icp4d.ICP4DConfig;
import com.ibm.cloud.sdk.core.security.noauth.NoauthAuthenticator;
import com.ibm.cloud.sdk.core.security.noauth.NoauthConfig;
import com.ibm.cloud.sdk.core.service.security.IamOptions;
import com.ibm.cloud.sdk.core.service.security.IamTokenManager;

public class AuthenticatorFactory {
    private AuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(AuthenticatorConfig config) throws IllegalArgumentException {
        config.validate();
        switch (config.authenticationType()) {
            case "iam": {
                return new IamTokenManager((IamOptions)config);
            }
            case "icp4d": {
                return new ICP4DAuthenticator((ICP4DConfig)config);
            }
            case "basic": {
                return new BasicAuthenticator((BasicAuthConfig)config);
            }
            case "noauth": {
                return new NoauthAuthenticator((NoauthConfig)config);
            }
        }
        throw new IllegalArgumentException("Unrecognized AuthenticatorConfig type: " + config.getClass().getName());
    }
}

