/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security.jwt;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Map;

public class JsonWebToken {
    private static Base64.Decoder decoder = Base64.getUrlDecoder();
    private Map<String, String> header;
    private Payload payload;

    public JsonWebToken(String encodedToken) {
        String[] decodedParts = encodedToken.split("\\.");
        Type headerType = new TypeToken<Map<String, String>>(){}.getType();
        String json = new String(decoder.decode(decodedParts[0]));
        this.header = (Map)GsonSingleton.getGson().fromJson(json, headerType);
        json = new String(decoder.decode(decodedParts[1]));
        this.payload = (Payload)GsonSingleton.getGson().fromJson(json, Payload.class);
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public class Payload {
        @SerializedName(value="iat")
        private Long issuedAt;
        @SerializedName(value="exp")
        private Long expiresAt;
        @SerializedName(value="sub")
        private String subject;
        @SerializedName(value="iss")
        private String issuer;
        @SerializedName(value="aud")
        private String audience;
        @SerializedName(value="uid")
        private String userId;
        private String username;
        private String role;

        public Long getIssuedAt() {
            return this.issuedAt;
        }

        public Long getExpiresAt() {
            return this.expiresAt;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public String getAudience() {
            return this.audience;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getUsername() {
            return this.username;
        }

        public String getRole() {
            return this.role;
        }
    }
}

