/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security.icp4d;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.icp4d.ICP4DConfig;
import com.ibm.cloud.sdk.core.security.icp4d.ICP4DToken;
import com.ibm.cloud.sdk.core.security.icp4d.ICP4DTokenResponse;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import java.io.IOException;
import java.util.Base64;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class ICP4DAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(ICP4DAuthenticator.class.getName());
    private static final String URL_SUFFIX = "/v1/preauth/validateAuth";
    private static final String ERROR_MSG = "Error while retrieving access token from ICP4D token service: ";
    private ICP4DConfig config;
    private ICP4DToken tokenData;

    private ICP4DAuthenticator() {
    }

    public ICP4DAuthenticator(ICP4DConfig config) {
        this.config = config;
    }

    @Override
    public String authenticationType() {
        return "icp4d";
    }

    @Override
    public void authenticate(Request.Builder builder) {
        builder.addHeader("Authorization", "Bearer " + this.getToken());
    }

    protected String getToken() {
        String token;
        if (StringUtils.isNotEmpty((CharSequence)this.config.getUserManagedAccessToken())) {
            token = this.config.getUserManagedAccessToken();
        } else {
            if (this.tokenData == null || !this.tokenData.isTokenValid()) {
                this.tokenData = this.requestToken();
            }
            token = this.tokenData.accessToken;
        }
        return token;
    }

    protected ICP4DToken requestToken() {
        String requestUrl = this.config.getUrl() + URL_SUFFIX;
        requestUrl = requestUrl.replace("//", "/");
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(requestUrl, new String[0]));
        builder.header("Authorization", this.buildBasicAuthHeader());
        ICP4DTokenResponse response = this.invokeRequest(builder.build());
        return new ICP4DToken(response);
    }

    private String buildBasicAuthHeader() {
        return "Basic " + Base64.getEncoder().encodeToString((this.config.getUsername() + ":" + this.config.getPassword()).getBytes());
    }

    private ICP4DTokenResponse invokeRequest(final Request request) {
        final ICP4DTokenResponse[] returnToken = new ICP4DTokenResponse[1];
        final boolean disableSSL = this.config.isDisableSSLVerification();
        Thread restCall = new Thread(new Runnable(){

            @Override
            public void run() {
                OkHttpClient client = HttpClientSingleton.getInstance().createHttpClient();
                if (disableSSL) {
                    HttpConfigOptions httpOptions = new HttpConfigOptions.Builder().disableSslVerification(true).build();
                    client = HttpClientSingleton.getInstance().configureClient(client, httpOptions);
                }
                Call call = client.newCall(request);
                ResponseConverter converter = ResponseConverterUtils.getObject(ICP4DTokenResponse.class);
                try {
                    Response response = call.execute();
                    if (response.code() >= 400) {
                        throw new ServiceResponseException(response.code(), response);
                    }
                    returnToken[0] = (ICP4DTokenResponse)converter.convert(response);
                }
                catch (IOException e) {
                    throw new RuntimeException(ICP4DAuthenticator.ERROR_MSG, e);
                }
            }
        });
        restCall.start();
        try {
            restCall.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(ERROR_MSG, e);
        }
        return returnToken[0];
    }
}

