/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.http.ServiceCallback;
import com.ibm.cloud.sdk.core.service.exception.BadRequestException;
import com.ibm.cloud.sdk.core.service.exception.ConflictException;
import com.ibm.cloud.sdk.core.service.exception.ForbiddenException;
import com.ibm.cloud.sdk.core.service.exception.InternalServerErrorException;
import com.ibm.cloud.sdk.core.service.exception.NotFoundException;
import com.ibm.cloud.sdk.core.service.exception.RequestTooLargeException;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.service.exception.ServiceUnavailableException;
import com.ibm.cloud.sdk.core.service.exception.TooManyRequestsException;
import com.ibm.cloud.sdk.core.service.exception.UnauthorizedException;
import com.ibm.cloud.sdk.core.service.exception.UnsupportedException;
import com.ibm.cloud.sdk.core.service.security.IamOptions;
import com.ibm.cloud.sdk.core.service.security.IamTokenManager;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import io.reactivex.Single;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseService {
    private static final String BASIC = "Basic ";
    private static final String BEARER = "Bearer ";
    private static final String APIKEY_AS_USERNAME = "apikey";
    private static final String ICP_PREFIX = "icp-";
    private static final Logger LOG = Logger.getLogger(BaseService.class.getName());
    private String apiKey;
    private String username;
    private String password;
    private String endPoint;
    private String defaultEndPoint;
    private final String name;
    private IamTokenManager tokenManager;
    private OkHttpClient client;
    private Headers defaultHeaders = null;
    private boolean skipAuthentication = false;
    protected static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/((json)|(merge\\-patch\\+json))(;.*)?");
    protected static final Pattern JSON_PATCH_MIME_PATTERN = Pattern.compile("(?i)application\\/json\\-patch\\+json(;.*)?");

    public BaseService(String name) {
        this.name = name;
        CredentialUtils.ServiceCredentials fileCredentials = CredentialUtils.getFileCredentials(name);
        if (!fileCredentials.isEmpty()) {
            this.setCredentialFields(fileCredentials);
        } else {
            this.setCredentialFields(CredentialUtils.getCredentialsFromVcap(name));
        }
        this.client = this.configureHttpClient();
    }

    private void setCredentialFields(CredentialUtils.ServiceCredentials serviceCredentials) {
        this.setEndPoint(serviceCredentials.getUrl());
        if (serviceCredentials.getUsername() != null && serviceCredentials.getPassword() != null) {
            this.setUsernameAndPassword(serviceCredentials.getUsername(), serviceCredentials.getPassword());
        } else if (serviceCredentials.getOldApiKey() != null) {
            this.setApiKey(serviceCredentials.getOldApiKey());
        }
        if (serviceCredentials.getIamApiKey() != null) {
            IamOptions iamOptions = new IamOptions.Builder().apiKey(serviceCredentials.getIamApiKey()).url(serviceCredentials.getIamUrl()).build();
            this.tokenManager = new IamTokenManager(iamOptions);
        }
    }

    public static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && JSON_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static boolean isJsonPatchMimeType(String mimeType) {
        return mimeType != null && JSON_PATCH_MIME_PATTERN.matcher(mimeType).matches();
    }

    protected OkHttpClient configureHttpClient() {
        return HttpClientSingleton.getInstance().createHttpClient();
    }

    public void configureClient(HttpConfigOptions options) {
        this.client = HttpClientSingleton.getInstance().configureClient(options);
    }

    private Call createCall(Request request) {
        Request.Builder builder = request.newBuilder();
        if (request.headers().get("User-Agent") == null) {
            this.setUserAgent(builder);
        }
        this.setDefaultHeaders(builder);
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        return this.client.newCall(newRequest);
    }

    private void setUserAgent(Request.Builder builder) {
        String userAgent = RequestUtils.getUserAgent();
        builder.header("User-Agent", userAgent);
    }

    protected void setDefaultHeaders(Request.Builder builder) {
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
        }
    }

    protected final <T> ServiceCall<T> createServiceCall(Request request, ResponseConverter<T> converter) {
        Call call = this.createCall(request);
        return new WatsonServiceCall<T>(call, converter);
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public boolean isTokenManagerSet() {
        return this.tokenManager != null;
    }

    public String getName() {
        return this.name;
    }

    public void setApiKey(String apiKey) {
        if (CredentialUtils.hasBadStartOrEndChar(apiKey)) {
            throw new IllegalArgumentException("The API key shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
        if (this.endPoint.equals(this.defaultEndPoint)) {
            this.endPoint = "https://gateway-a.watsonplatform.net/visual-recognition/api";
        }
        this.apiKey = apiKey;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.tokenManager != null) {
            String accessToken = this.tokenManager.getToken();
            builder.addHeader("Authorization", BEARER + accessToken);
        } else {
            if (this.getApiKey() == null) {
                if (this.skipAuthentication) {
                    return;
                }
                throw new IllegalArgumentException("apiKey or username and password were not specified");
            }
            builder.addHeader("Authorization", this.apiKey.startsWith(BASIC) ? this.apiKey : BASIC + this.apiKey);
        }
    }

    public void setEndPoint(String endPoint) {
        if (CredentialUtils.hasBadStartOrEndChar(endPoint)) {
            throw new IllegalArgumentException("The URL shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
        if (endPoint != null && !endPoint.isEmpty()) {
            String newEndPoint;
            String string = newEndPoint = endPoint.endsWith("/") ? endPoint.substring(0, endPoint.length() - 1) : endPoint;
            if (this.endPoint == null) {
                this.defaultEndPoint = newEndPoint;
            }
            this.endPoint = newEndPoint;
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        if (CredentialUtils.hasBadStartOrEndChar(username) || CredentialUtils.hasBadStartOrEndChar(password)) {
            throw new IllegalArgumentException("The username and password shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
        if (username.equals(APIKEY_AS_USERNAME) && !password.startsWith(ICP_PREFIX)) {
            IamOptions iamOptions = new IamOptions.Builder().apiKey(password).build();
            this.setIamCredentials(iamOptions);
        } else {
            this.username = username;
            this.password = password;
            this.apiKey = Credentials.basic((String)username, (String)password);
            this.clearIamCredentials();
        }
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers == null ? null : Headers.of(headers);
    }

    public void setIamCredentials(IamOptions iamOptions) {
        this.tokenManager = new IamTokenManager(iamOptions);
    }

    private void clearIamCredentials() {
        this.tokenManager = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append(" [");
        if (this.endPoint != null) {
            builder.append("endPoint=").append(this.endPoint);
        }
        return builder.append(']').toString();
    }

    protected <T> T processServiceCall(ResponseConverter<T> converter, Response response) {
        if (response.isSuccessful()) {
            return converter.convert(response);
        }
        switch (response.code()) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new UnauthorizedException(response);
            }
            case 403: {
                throw new ForbiddenException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 406: {
                throw new ForbiddenException(response);
            }
            case 409: {
                throw new ConflictException(response);
            }
            case 413: {
                throw new RequestTooLargeException(response);
            }
            case 415: {
                throw new UnsupportedException(response);
            }
            case 429: {
                throw new TooManyRequestsException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        throw new ServiceResponseException(response.code(), response);
    }

    public void setSkipAuthentication(boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
    }

    class WatsonServiceCall<T>
    implements ServiceCall<T> {
        private Call call;
        private ResponseConverter<T> converter;

        WatsonServiceCall(Call call, ResponseConverter<T> converter) {
            this.call = call;
            this.converter = converter;
        }

        @Override
        public ServiceCall<T> addHeader(String name, String value) {
            Request.Builder builder = this.call.request().newBuilder();
            builder.header(name, value);
            this.call = BaseService.this.client.newCall(builder.build());
            return this;
        }

        @Override
        public com.ibm.cloud.sdk.core.http.Response<T> execute() {
            try {
                Response response = this.call.execute();
                T responseModel = BaseService.this.processServiceCall(this.converter, response);
                return new com.ibm.cloud.sdk.core.http.Response<T>(responseModel, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void enqueue(final ServiceCallback<T> callback) {
            this.call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    callback.onFailure(e);
                }

                public void onResponse(Call call, Response response) {
                    try {
                        Object responseModel = BaseService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                        callback.onResponse(new com.ibm.cloud.sdk.core.http.Response(responseModel, response));
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                }
            });
        }

        @Override
        public Single<com.ibm.cloud.sdk.core.http.Response<T>> reactiveRequest() {
            return Single.fromCallable((Callable)new Callable<com.ibm.cloud.sdk.core.http.Response<T>>(){

                @Override
                public com.ibm.cloud.sdk.core.http.Response<T> call() throws Exception {
                    Response response = WatsonServiceCall.this.call.execute();
                    Object responseModel = BaseService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                    return new com.ibm.cloud.sdk.core.http.Response(responseModel, response);
                }
            });
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.call.isExecuted()) {
                Request r = this.call.request();
                LOG.warning(r.method() + " request to " + r.url() + " has not been sent. Did you forget to call execute()?");
            }
        }
    }
}

