/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.security;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.service.security.IamOptions;
import com.ibm.cloud.sdk.core.service.security.IamToken;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class IamTokenManager {
    private String userManagedAccessToken;
    private String apiKey;
    private String url;
    private IamToken tokenData;
    private static final Logger LOG = Logger.getLogger(IamTokenManager.class.getName());
    private static final String ERROR_MESSAGE = "Error getting IAM token from API";
    private static final String DEFAULT_AUTHORIZATION = "Basic Yng6Yng=";
    private static final String DEFAULT_IAM_URL = "https://iam.bluemix.net/identity/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REQUEST_GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String REFRESH_GRANT_TYPE = "refresh_token";
    private static final String API_KEY = "apikey";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String CLOUD_IAM = "cloud_iam";
    private static final String REFRESH_TOKEN = "refresh_token";

    public IamTokenManager(IamOptions options) {
        if (options.getApiKey() != null) {
            if (CredentialUtils.hasBadStartOrEndChar(options.getApiKey())) {
                throw new IllegalArgumentException("The IAM API key shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
            }
            this.apiKey = options.getApiKey();
        }
        this.url = options.getUrl() != null ? options.getUrl() : DEFAULT_IAM_URL;
        this.userManagedAccessToken = options.getAccessToken();
        this.tokenData = new IamToken();
    }

    public String getToken() {
        String token = this.userManagedAccessToken != null ? this.userManagedAccessToken : (this.tokenData.getAccessToken() == null || this.isRefreshTokenExpired() ? this.requestToken() : (this.isAccessTokenExpired() ? this.refreshToken() : this.tokenData.getAccessToken()));
        return token;
    }

    private String requestToken() {
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.url, new String[0]));
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        builder.header("Authorization", DEFAULT_AUTHORIZATION);
        FormBody formBody = new FormBody.Builder().add(GRANT_TYPE, REQUEST_GRANT_TYPE).add(API_KEY, this.apiKey).add(RESPONSE_TYPE, CLOUD_IAM).build();
        builder.body((RequestBody)formBody);
        this.tokenData = this.callIamApi(builder.build());
        return this.tokenData.getAccessToken();
    }

    private String refreshToken() {
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.url, new String[0]));
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        builder.header("Authorization", DEFAULT_AUTHORIZATION);
        FormBody formBody = new FormBody.Builder().add(GRANT_TYPE, "refresh_token").add("refresh_token", this.tokenData.getRefreshToken()).build();
        builder.body((RequestBody)formBody);
        this.tokenData = this.callIamApi(builder.build());
        return this.tokenData.getAccessToken();
    }

    private boolean isAccessTokenExpired() {
        if (this.tokenData.getExpiresIn() == null || this.tokenData.getExpiration() == null) {
            return true;
        }
        Double fractionOfTimeToLive = 0.8;
        Long timeToLive = this.tokenData.getExpiresIn();
        Long expirationTime = this.tokenData.getExpiration();
        Double refreshTime = (double)expirationTime.longValue() - (double)timeToLive.longValue() * (1.0 - fractionOfTimeToLive);
        Double currentTime = Math.floor(System.currentTimeMillis() / 1000L);
        return refreshTime < currentTime;
    }

    private boolean isRefreshTokenExpired() {
        if (this.tokenData.getExpiration() == null) {
            return true;
        }
        int sevenDays = 604800;
        Double currentTime = Math.floor(System.currentTimeMillis() / 1000L);
        Long newTokenTime = this.tokenData.getExpiration() + (long)sevenDays;
        return (double)newTokenTime.longValue() < currentTime;
    }

    private IamToken callIamApi(final Request request) {
        final IamToken[] returnToken = new IamToken[1];
        Thread iamApiCall = new Thread(new Runnable(){

            @Override
            public void run() {
                Call call = HttpClientSingleton.getInstance().createHttpClient().newCall(request);
                ResponseConverter<IamToken> converter = ResponseConverterUtils.getObject(IamToken.class);
                try {
                    Response response = call.execute();
                    returnToken[0] = converter.convert(response);
                }
                catch (IOException e) {
                    LOG.severe(IamTokenManager.ERROR_MESSAGE);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        iamApiCall.start();
        try {
            iamApiCall.join();
        }
        catch (InterruptedException e) {
            LOG.severe(ERROR_MESSAGE);
            e.printStackTrace();
        }
        return returnToken[0];
    }
}

