/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import com.ibm.cloud.sdk.core.util.HttpLogging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.commons.io.IOUtils;

public class InputStreamRequestBody
extends RequestBody {
    private InputStream inputStream;
    private MediaType mediaType;
    private byte[] bytes;

    public static RequestBody create(MediaType mediaType, InputStream inputStream) {
        return new InputStreamRequestBody(inputStream, mediaType);
    }

    private InputStreamRequestBody(InputStream inputStream, MediaType mediaType) {
        this.inputStream = inputStream;
        this.mediaType = mediaType;
        if (HttpLogging.getLoggingInterceptor().getLevel().equals((Object)HttpLoggingInterceptor.Level.BODY)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bytes = outputStream.toByteArray();
        }
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = this.bytes != null ? Okio.source((InputStream)new ByteArrayInputStream(this.bytes)) : Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(source);
            throw throwable;
        }
        Util.closeQuietly((Closeable)source);
    }
}

