/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.exception;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.Headers;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseUtils;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.Response;

public class ServiceResponseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_ERROR = "error";
    private static final String MESSAGE_ERROR_2 = "error_message";
    private static final String MESSAGE_ERROR_3 = "message";
    private static final String[] ERROR_KEYS = new String[]{"error", "error_message", "message"};
    private static final Type debuggingInfoType = new TypeToken<Map<String, Object>>(){}.getType();
    private final int statusCode;
    private String message;
    private Headers headers;
    private Map<String, Object> debuggingInfo;

    public ServiceResponseException(int statusCode, Response response) {
        this.statusCode = statusCode;
        this.headers = new Headers(response.headers());
        String responseString = ResponseUtils.getString(response);
        try {
            JsonObject jsonObject = ResponseUtils.getJsonObject(responseString);
            for (String errorKey : ERROR_KEYS) {
                if (!jsonObject.has(errorKey)) continue;
                this.message = jsonObject.remove(errorKey).getAsString();
                break;
            }
            this.debuggingInfo = (Map)GsonSingleton.getGson().fromJson((JsonElement)jsonObject, debuggingInfoType);
        }
        catch (Exception e) {
            this.message = responseString;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getDebuggingInfo() {
        return this.debuggingInfo;
    }
}

