/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;

public class Attachment
extends GenericModel {
    @SerializedName(value="content_type")
    protected String contentType;
    protected byte[] data;
    protected String digest;
    @SerializedName(value="encoded_length")
    protected Long encodedLength;
    protected String encoding;
    protected Boolean follows;
    protected Long length;
    protected Long revpos;
    protected Boolean stub;

    protected Attachment() {
    }

    protected Attachment(Builder builder) {
        this.contentType = builder.contentType;
        this.data = builder.data;
        this.digest = builder.digest;
        this.encodedLength = builder.encodedLength;
        this.encoding = builder.encoding;
        this.follows = builder.follows;
        this.length = builder.length;
        this.revpos = builder.revpos;
        this.stub = builder.stub;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String contentType() {
        return this.contentType;
    }

    public byte[] data() {
        return this.data;
    }

    public String digest() {
        return this.digest;
    }

    public Long encodedLength() {
        return this.encodedLength;
    }

    public String encoding() {
        return this.encoding;
    }

    public Boolean follows() {
        return this.follows;
    }

    public Long length() {
        return this.length;
    }

    public Long revpos() {
        return this.revpos;
    }

    public Boolean stub() {
        return this.stub;
    }

    public static class Builder {
        private String contentType;
        private byte[] data;
        private String digest;
        private Long encodedLength;
        private String encoding;
        private Boolean follows;
        private Long length;
        private Long revpos;
        private Boolean stub;

        private Builder(Attachment attachment) {
            this.contentType = attachment.contentType;
            this.data = attachment.data;
            this.digest = attachment.digest;
            this.encodedLength = attachment.encodedLength;
            this.encoding = attachment.encoding;
            this.follows = attachment.follows;
            this.length = attachment.length;
            this.revpos = attachment.revpos;
            this.stub = attachment.stub;
        }

        public Builder() {
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public Builder encodedLength(long encodedLength) {
            this.encodedLength = encodedLength;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder follows(Boolean follows) {
            this.follows = follows;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder revpos(long revpos) {
            this.revpos = revpos;
            return this;
        }

        public Builder stub(Boolean stub) {
            this.stub = stub;
            return this;
        }
    }
}

