/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.AllDocsQuery;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostDesignDocsQueriesOptions
extends GenericModel {
    protected String db;
    protected String accept;
    protected List<AllDocsQuery> queries;

    protected PostDesignDocsQueriesOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.accept = builder.accept;
        this.queries = builder.queries;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String accept() {
        return this.accept;
    }

    public List<AllDocsQuery> queries() {
        return this.queries;
    }

    public static class Builder {
        private String db;
        private String accept;
        private List<AllDocsQuery> queries;

        private Builder(PostDesignDocsQueriesOptions postDesignDocsQueriesOptions) {
            this.db = postDesignDocsQueriesOptions.db;
            this.accept = postDesignDocsQueriesOptions.accept;
            this.queries = postDesignDocsQueriesOptions.queries;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostDesignDocsQueriesOptions build() {
            return new PostDesignDocsQueriesOptions(this);
        }

        public Builder addQueries(AllDocsQuery queries) {
            Validator.notNull((Object)((Object)queries), (String)"queries cannot be null");
            if (this.queries == null) {
                this.queries = new ArrayList<AllDocsQuery>();
            }
            this.queries.add(queries);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder queries(List<AllDocsQuery> queries) {
            this.queries = queries;
            return this;
        }
    }
}

