/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.DocumentResult;
import com.ibm.cloud.cloudant.v1.model.Ok;
import com.ibm.cloud.cloudant.v1.model.PostDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutDatabaseOptions;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;

public class CreateDbAndDoc {
    public static void main(String[] args) {
        String exampleDbName;
        Cloudant client;
        block3: {
            client = Cloudant.newInstance();
            exampleDbName = "orders";
            PutDatabaseOptions putDbOptions = new PutDatabaseOptions.Builder().db(exampleDbName).build();
            try {
                Ok putDatabaseResult = (Ok)client.putDatabase(putDbOptions).execute().getResult();
                if (putDatabaseResult.isOk().booleanValue()) {
                    System.out.println("\"" + exampleDbName + "\" database created.");
                }
            }
            catch (ServiceResponseException sre) {
                if (sre.getStatusCode() != 412) break block3;
                System.out.println("Cannot create \"" + exampleDbName + "\" database, it already exists.");
            }
        }
        String exampleDocId = "example";
        Document exampleDocument = new Document();
        exampleDocument.setId(exampleDocId);
        exampleDocument.put("name", (Object)"Bob Smith");
        exampleDocument.put("joined", (Object)"2019-01-24T10:42:59.000Z");
        PostDocumentOptions createDocumentOptions = new PostDocumentOptions.Builder().db(exampleDbName).document(exampleDocument).build();
        DocumentResult createDocumentResponse = (DocumentResult)client.postDocument(createDocumentOptions).execute().getResult();
        exampleDocument.setRev(createDocumentResponse.getRev());
        System.out.println("You have created the document:\n" + exampleDocument);
    }
}

