/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.BatchletProxy;
import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.DeciderProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.batch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.batch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.batch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.batch.container.services.IBatchArtifactFactory;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.validation.ArtifactSignatureValidator;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.util.List;
import jsr352.batch.jsl.Property;

public class ProxyFactory {
    protected static ServicesManager servicesManager = ServicesManager.getInstance();
    protected static IBatchArtifactFactory batchArtifactFactory = (IBatchArtifactFactory)servicesManager.getService(ServicesManager.ServiceType.CONTAINER_ARTIFACT_FACTORY_SERVICE);

    static Object loadArtifact(String id) {
        Object loadedArtifact = null;
        try {
            loadedArtifact = batchArtifactFactory.load(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loadedArtifact;
    }

    public static DeciderProxy createDeciderProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        DeciderProxy proxy = new DeciderProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static BatchletProxy createBatchletProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        BatchletProxy proxy = new BatchletProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static CheckpointAlgorithmProxy createCheckpointAlgorithmProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        CheckpointAlgorithmProxy proxy = new CheckpointAlgorithmProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static ItemReaderProxy createItemReaderProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        ItemReaderProxy proxy = new ItemReaderProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static ItemProcessorProxy createItemProcessorProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        ItemProcessorProxy proxy = new ItemProcessorProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static ItemWriterProxy createItemWriterProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        return new ItemWriterProxy(loadedArtifact, props);
    }

    public static PartitionReducerProxy createPartitionReducerProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        PartitionReducerProxy proxy = new PartitionReducerProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static PartitionMapperProxy createPartitionMapperProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        PartitionMapperProxy proxy = new PartitionMapperProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static PartitionAnalyzerProxy createPartitionAnalyzerProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        PartitionAnalyzerProxy proxy = new PartitionAnalyzerProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }

    public static PartitionCollectorProxy createPartitionCollectorProxy(String id, List<Property> props) throws ArtifactValidationException {
        Object loadedArtifact = ProxyFactory.loadArtifact(id);
        PartitionCollectorProxy proxy = new PartitionCollectorProxy(loadedArtifact, props);
        ArtifactSignatureValidator.validate(proxy);
        return proxy;
    }
}

