/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.context.impl;

import com.ibm.batch.container.context.impl.MetricImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.FlowContext;
import javax.batch.runtime.context.StepContext;

public class StepContextImpl<T, P extends Externalizable>
implements StepContext<T, P> {
    private static final String sourceClass = StepContextImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private String stepId = null;
    private String batchStatus = null;
    private String exitStatus = null;
    private T transientUserData = null;
    private P persistentUserData = null;
    private long stepExecID = 0L;
    private Properties properties = new Properties();
    private ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    public StepContextImpl(String stepId) {
        this.stepId = stepId;
    }

    public String getBatchStatus() {
        return this.batchStatus;
    }

    public Exception getException() {
        return null;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public String getId() {
        return this.stepId;
    }

    public Metric[] getMetrics() {
        return this.metrics.values().toArray(new Metric[0]);
    }

    public MetricImpl getMetric(MetricImpl.Counter counter) {
        return (MetricImpl)this.metrics.get(counter.name());
    }

    public void addMetric(MetricImpl.Counter counter, long value) {
        this.metrics.putIfAbsent(counter.name(), new MetricImpl(counter, value));
    }

    public P getPersistentUserData() {
        return this.persistentUserData;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public T getTransientUserData() {
        return this.transientUserData;
    }

    public void setExitStatus(String status) {
        this.exitStatus = status;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Exit status set to: " + status + " for step id:" + this.getId());
        }
    }

    public void setBatchStatus(String status) {
        this.batchStatus = status;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Batch status set to: " + status + " for step id:" + this.getId());
        }
    }

    public void setPersistentUserData(P data) {
        this.persistentUserData = data;
    }

    public void setTransientUserData(T data) {
        this.transientUserData = data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" stepId: " + this.stepId);
        buf.append(", batchStatus: " + this.batchStatus);
        buf.append(", exitStatus: " + this.exitStatus);
        buf.append(", transientUserData: " + this.transientUserData);
        buf.append(", persistentUserData: " + this.persistentUserData);
        return buf.toString();
    }

    public long getStepExecutionId() {
        return this.stepExecID;
    }

    public List<FlowContext<T>> getBatchContexts() {
        return null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void setStepExecutionId(long stepExecutionId) {
        this.stepExecID = stepExecutionId;
    }
}

