/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.Process;
import javax.batch.annotation.Stop;
import jsr352.batch.jsl.Property;

public class BatchletProxy
extends AbstractProxy {
    private Method processMethod = null;
    private Method stopMethod = null;

    BatchletProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            Stop stop;
            Process process = method.getAnnotation(Process.class);
            if (process != null) {
                this.processMethod = method;
            }
            if ((stop = method.getAnnotation(Stop.class)) == null) continue;
            this.stopMethod = method;
        }
    }

    public String process() {
        String retVal = null;
        if (this.processMethod != null) {
            try {
                retVal = (String)this.processMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        return retVal;
    }

    public void stop() {
        if (this.stopMethod != null) {
            try {
                this.stopMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    public Method getProcessMethod() {
        return this.processMethod;
    }

    public Method getStopMethod() {
        return this.stopMethod;
    }
}

