/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.annotation.processor;

import com.ibm.batch.annotation.processor.XMLBeanDefinition;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.CheckpointAlgorithm;
import javax.batch.annotation.CheckpointListener;
import javax.batch.annotation.Decider;
import javax.batch.annotation.ItemProcessListener;
import javax.batch.annotation.ItemProcessor;
import javax.batch.annotation.ItemReadListener;
import javax.batch.annotation.ItemReader;
import javax.batch.annotation.ItemWriteListener;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.JobListener;
import javax.batch.annotation.PartitionAnalyzer;
import javax.batch.annotation.PartitionCollector;
import javax.batch.annotation.PartitionMapper;
import javax.batch.annotation.RetryListener;
import javax.batch.annotation.SkipListener;
import javax.batch.annotation.StepListener;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"javax.batch.annotation.*"})
public class BatchAnnotationProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(BatchAnnotationProcessor.class.getName());
    Vector<XMLBeanDefinition> beanDefinitions = new Vector();
    private static final String BATCHXML = "META-INF/batch.xml";
    private Messager messager;
    private Filer filer;
    private FileObject resourceFile;

    private void writeBatchXML() {
        try {
            PrintWriter pw = new PrintWriter(this.resourceFile.openWriter());
            pw.print("<batch-artifacts>\n");
            for (XMLBeanDefinition beanDef : this.beanDefinitions) {
                pw.print("    " + beanDef.getXMLString() + "\n");
            }
            pw.print("</batch-artifacts>\n");
            pw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.messager = pe.getMessager();
        this.filer = pe.getFiler();
        if (this.filer == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "No filer!");
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Overwriting META-INF/batch.xml");
            }
            this.resourceFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", BATCHXML, null);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Successfully overwrote META-INF/batch.xml");
            }
        }
        catch (FilerException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Cannot create META-INF/batch.xml :" + e.getMessage());
            }
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getId(Element element, String value) {
        String retVal = null;
        if (value.equals("")) {
            String simpleName = element.getSimpleName().toString();
            String simpleNameFirst = simpleName.substring(0, 1).toLowerCase();
            String simpleNameRest = simpleName.substring(1);
            retVal = simpleNameFirst + simpleNameRest;
        } else {
            retVal = value;
        }
        return retVal;
    }

    private void processRootElement(Element element) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing root element: " + element.toString());
        }
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        XMLBeanDefinition beanXML = null;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String className;
            String xmlElement;
            String beanID;
            String value;
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Processing annotation type: " + annotationType.toString());
            }
            if (annotationType.equals(JobListener.class.getName())) {
                value = element.getAnnotation(JobListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(JobListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(CheckpointListener.class.getName())) {
                value = element.getAnnotation(CheckpointListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(CheckpointListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemProcessListener.class.getName())) {
                value = element.getAnnotation(ItemProcessListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemProcessListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemProcessor.class.getName())) {
                value = element.getAnnotation(ItemProcessor.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemProcessor.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemReader.class.getName())) {
                value = element.getAnnotation(ItemReader.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemReader.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemReadListener.class.getName())) {
                value = element.getAnnotation(ItemReadListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemReadListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemWriteListener.class.getName())) {
                value = element.getAnnotation(ItemWriteListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemWriteListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(ItemWriter.class.getName())) {
                value = element.getAnnotation(ItemWriter.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(ItemWriter.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(RetryListener.class.getName())) {
                value = element.getAnnotation(RetryListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(RetryListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(StepListener.class.getName())) {
                value = element.getAnnotation(StepListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(StepListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(SkipListener.class.getName())) {
                value = element.getAnnotation(SkipListener.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(SkipListener.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(Batchlet.class.getName())) {
                value = element.getAnnotation(Batchlet.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(Batchlet.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(Decider.class.getName())) {
                value = element.getAnnotation(Decider.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(Decider.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(PartitionCollector.class.getName())) {
                value = element.getAnnotation(PartitionCollector.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(PartitionCollector.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(PartitionAnalyzer.class.getName())) {
                value = element.getAnnotation(PartitionAnalyzer.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(PartitionAnalyzer.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(PartitionMapper.class.getName())) {
                value = element.getAnnotation(PartitionMapper.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(PartitionMapper.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            } else if (annotationType.equals(CheckpointAlgorithm.class.getName())) {
                value = element.getAnnotation(CheckpointAlgorithm.class).value();
                beanID = this.getId(element, value);
                xmlElement = XMLBeanDefinition.getXMLElement(CheckpointAlgorithm.class);
                className = element.toString();
                beanXML = new XMLBeanDefinition(xmlElement, beanID, className);
            }
            if (beanXML == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Create batch artifact bean definition: " + beanXML.getXMLString());
            }
            this.beanDefinitions.add(beanXML);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing annotations");
        }
        if (!roundEnv.processingOver()) {
            Set<? extends Element> elements = roundEnv.getRootElements();
            for (Element element : elements) {
                this.processRootElement(element);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing: META-INF/batch.xml");
            }
            this.writeBatchXML();
        }
        return true;
    }
}

