/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterStep;
import javax.batch.annotation.BeforeStep;
import jsr352.batch.jsl.Property;

public class StepListenerProxy
extends AbstractProxy {
    private Method beforeStepMethod = null;
    private Method afterStepMethod = null;

    StepListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            AfterStep afterStep;
            BeforeStep beforeStep = method.getAnnotation(BeforeStep.class);
            if (beforeStep != null) {
                this.beforeStepMethod = method;
            }
            if ((afterStep = method.getAnnotation(AfterStep.class)) == null) continue;
            this.afterStepMethod = method;
        }
    }

    public void beforeStep() {
        if (this.beforeStepMethod != null) {
            try {
                this.beforeStepMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterStep() {
        if (this.afterStepMethod != null) {
            try {
                this.afterStepMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

