/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterJob;
import javax.batch.annotation.AfterStep;
import javax.batch.annotation.BeforeJob;
import javax.batch.annotation.BeforeStep;
import jsr352.batch.jsl.Property;

public class PartitionReducerProxy
extends AbstractProxy {
    private Method partitionReducerBeginMethod = null;
    private Method partitionReducerBeforeCompletionMethod = null;
    private Method partitionReducerRollbackMethod = null;
    private Method partitionReducerAfterCompletionMethod = null;

    PartitionReducerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            BeforeStep beforeStep;
            AfterStep afterStep;
            BeforeJob beforeJob;
            AfterJob afterJob = method.getAnnotation(AfterJob.class);
            if (afterJob != null) {
                this.partitionReducerBeginMethod = method;
            }
            if ((beforeJob = method.getAnnotation(BeforeJob.class)) != null) {
                this.partitionReducerBeforeCompletionMethod = method;
            }
            if ((afterStep = method.getAnnotation(AfterStep.class)) != null) {
                this.partitionReducerRollbackMethod = method;
            }
            if ((beforeStep = method.getAnnotation(BeforeStep.class)) == null) continue;
            this.partitionReducerAfterCompletionMethod = method;
        }
    }

    public void partitionReducerBegin() {
        if (this.partitionReducerBeginMethod != null) {
            try {
                this.partitionReducerBeginMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void partitionReducerBeforeCompletion() {
        if (this.partitionReducerBeforeCompletionMethod != null) {
            try {
                this.partitionReducerBeforeCompletionMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void partitionReducerRollback() {
        if (this.partitionReducerRollbackMethod != null) {
            try {
                this.partitionReducerRollbackMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void partitionReducerAfterCompletion(String status) {
        if (this.partitionReducerAfterCompletionMethod != null) {
            try {
                this.partitionReducerAfterCompletionMethod.invoke(this.delegate, status);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

