/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appconfiguration.android.lib.feature.internal;

import android.content.Context;
import com.ibm.appconfiguration.android.lib.core.APIManager;
import com.ibm.appconfiguration.android.lib.core.BaseRequest;
import com.ibm.appconfiguration.android.lib.core.Logger;
import com.ibm.appconfiguration.android.lib.core.Response;
import com.ibm.appconfiguration.android.lib.core.ResponseListener;
import com.ibm.appconfiguration.android.lib.feature.internal.URLBuilder;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0013H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000RZ\u0010\u0005\u001aB\u0012\u0004\u0012\u00020\u0007\u00128\u00126\u0012\u0004\u0012\u00020\u0007\u0012,\u0012*\u0012\u0004\u0012\u00020\u0007\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001`\t0\u00060\u00060\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ibm/appconfiguration/android/lib/feature/internal/Metering;", "", "()V", "appContext", "Landroid/content/Context;", "meteringData", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getMeteringData", "()Ljava/util/concurrent/ConcurrentHashMap;", "setMeteringData", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "sendInterval", "", "urlBuilder", "Lcom/ibm/appconfiguration/android/lib/feature/internal/URLBuilder;", "addMetering", "", "guid", "collectionId", "feature", "init", "sendMetering", "Factory", "lib_release"})
public final class Metering {
    private long sendInterval = 600000L;
    private Context appContext;
    private URLBuilder urlBuilder;
    @NotNull
    private ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>>> meteringData = new ConcurrentHashMap();
    private static Metering instance;
    @NotNull
    public static final Factory Factory;

    @NotNull
    public final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>>> getMeteringData() {
        return this.meteringData;
    }

    public final void setMeteringData(@NotNull ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>>> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, (String)"<set-?>");
        this.meteringData = concurrentHashMap;
    }

    public final void init(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
    }

    public final void addMetering(@NotNull String guid, @NotNull String collectionId, @NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        boolean hasData = false;
        HashMap featureJson = new HashMap();
        ((Map)featureJson).put("count", 1);
        String string = Instant.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Instant.now().toString()");
        String currentDate = string;
        ((Map)featureJson).put("evaluation_time", currentDate);
        if (this.meteringData.containsKey(guid)) {
            ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap = this.meteringData.get(guid);
            Intrinsics.checkNotNull(concurrentHashMap);
            if (concurrentHashMap.containsKey(collectionId)) {
                ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap2 = this.meteringData.get(guid);
                Intrinsics.checkNotNull(concurrentHashMap2);
                ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap3 = concurrentHashMap2.get(collectionId);
                Intrinsics.checkNotNull(concurrentHashMap3);
                if (concurrentHashMap3.containsKey(feature)) {
                    hasData = true;
                    ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap4 = this.meteringData.get(guid);
                    Intrinsics.checkNotNull(concurrentHashMap4);
                    ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap5 = concurrentHashMap4.get(collectionId);
                    Intrinsics.checkNotNull(concurrentHashMap5);
                    HashMap<String, Object> hashMap = concurrentHashMap5.get(feature);
                    Intrinsics.checkNotNull(hashMap);
                    Intrinsics.checkNotNullExpressionValue(hashMap, (String)"meteringData[guid]!![collectionId]!![feature]!!");
                    ((Map)hashMap).put("evaluation_time", currentDate);
                    ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap6 = this.meteringData.get(guid);
                    Intrinsics.checkNotNull(concurrentHashMap6);
                    ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap7 = concurrentHashMap6.get(collectionId);
                    Intrinsics.checkNotNull(concurrentHashMap7);
                    HashMap<String, Object> hashMap2 = concurrentHashMap7.get(feature);
                    Intrinsics.checkNotNull(hashMap2);
                    Object object = hashMap2.get("count");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int count = (Integer)object;
                    ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap8 = this.meteringData.get(guid);
                    Intrinsics.checkNotNull(concurrentHashMap8);
                    ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap9 = concurrentHashMap8.get(collectionId);
                    Intrinsics.checkNotNull(concurrentHashMap9);
                    HashMap<String, Object> hashMap3 = concurrentHashMap9.get(feature);
                    Intrinsics.checkNotNull(hashMap3);
                    Intrinsics.checkNotNullExpressionValue(hashMap3, (String)"meteringData[guid]!![collectionId]!![feature]!!");
                    ((Map)hashMap3).put("count", count + 1);
                } else {
                    ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap10 = this.meteringData.get(guid);
                    Intrinsics.checkNotNull(concurrentHashMap10);
                    ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap11 = concurrentHashMap10.get(collectionId);
                    Intrinsics.checkNotNull(concurrentHashMap11);
                    Intrinsics.checkNotNullExpressionValue(concurrentHashMap11, (String)"meteringData[guid]!![collectionId]!!");
                    ((Map)concurrentHashMap11).put(feature, new HashMap());
                }
            } else {
                ConcurrentHashMap featureMap = new ConcurrentHashMap();
                ((Map)featureMap).put(feature, new HashMap());
                ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap12 = this.meteringData.get(guid);
                Intrinsics.checkNotNull(concurrentHashMap12);
                Intrinsics.checkNotNullExpressionValue(concurrentHashMap12, (String)"this.meteringData[guid]!!");
                ((Map)concurrentHashMap12).put(collectionId, featureMap);
            }
        } else {
            ConcurrentHashMap featureMap = new ConcurrentHashMap();
            ConcurrentHashMap collectionIdMap = new ConcurrentHashMap();
            ((Map)featureMap).put(feature, new HashMap());
            ((Map)collectionIdMap).put(collectionId, featureMap);
            ((Map)this.meteringData).put(guid, collectionIdMap);
        }
        if (!hasData) {
            ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>> concurrentHashMap = this.meteringData.get(guid);
            Intrinsics.checkNotNull(concurrentHashMap);
            ConcurrentHashMap<String, HashMap<String, Object>> concurrentHashMap13 = concurrentHashMap.get(collectionId);
            Intrinsics.checkNotNull(concurrentHashMap13);
            HashMap<String, Object> hashMap = concurrentHashMap13.get(feature);
            Intrinsics.checkNotNull(hashMap);
            hashMap.putAll(featureJson);
        }
    }

    private final void sendMetering() {
        if (this.appContext == null || this.urlBuilder == null) {
            return;
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, HashMap<String, Object>>>> sendMeteringData = this.meteringData;
        this.meteringData = new ConcurrentHashMap();
        Map map = sendMeteringData;
        boolean bl = false;
        for (Map.Entry collections : map.entrySet()) {
            String guid = (String)collections.getKey();
            JSONObject dataToSend = new JSONObject();
            Map map2 = (Map)collections.getValue();
            boolean bl2 = false;
            for (Map.Entry collection : map2.entrySet()) {
                try {
                    dataToSend.put("collection_id", collection.getKey());
                    JSONArray array = new JSONArray();
                    Map map3 = (Map)collection.getValue();
                    boolean bl3 = false;
                    for (Map.Entry feature : map3.entrySet()) {
                        HashMap featuresObj = (HashMap)feature.getValue();
                        JSONObject featureJson = new JSONObject();
                        featureJson.put("feature_id", feature.getKey());
                        featureJson.put("evaluation_time", featuresObj.get("evaluation_time"));
                        featureJson.put("count", featuresObj.get("count"));
                        array.put((Object)featureJson);
                    }
                    dataToSend.put("usages", (Object)array);
                    URLBuilder uRLBuilder = this.urlBuilder;
                    Intrinsics.checkNotNull((Object)uRLBuilder);
                    String string = uRLBuilder.getMeteringurl(guid);
                    if (string == null) {
                        string = "";
                    }
                    String configURL = string;
                    Context context = this.appContext;
                    Intrinsics.checkNotNull((Object)context);
                    APIManager apiManager = APIManager.Companion.newInstance(context, configURL, BaseRequest.Companion.getPOST());
                    apiManager.setJSONRequestBody(dataToSend);
                    apiManager.setResponseListener(new ResponseListener(){

                        public void onSuccess(@NotNull Response response) {
                            int status;
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            int n = status = response.getStatus();
                            if (200 <= n && 299 >= n) {
                                Logger.Companion.debug("Successfully pushed the data to metering'");
                            } else {
                                Logger.Companion.error("Error while sending the metering data. Status code " + status);
                            }
                        }

                        public void onFailure(@Nullable Response response, @Nullable Throwable t, @Nullable JSONObject extendedInfo) {
                            Logger.Companion.error(String.valueOf(String.valueOf(extendedInfo)));
                        }
                    });
                    apiManager.execute();
                }
                catch (JSONException e) {
                    Logger.Companion.error(String.valueOf(e.getMessage()));
                }
            }
        }
    }

    public Metering() {
        this.urlBuilder = URLBuilder.Factory.getInstance();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                this.sendMetering();
            }
        }, 5L, this.sendInterval);
    }

    static {
        Factory = new Factory(null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ibm/appconfiguration/android/lib/feature/internal/Metering$Factory;", "", "()V", "instance", "Lcom/ibm/appconfiguration/android/lib/feature/internal/Metering;", "getInstance", "lib_release"})
    public static final class Factory {
        @NotNull
        public final Metering getInstance() {
            if (instance == null) {
                instance = new Metering();
            }
            Metering metering = instance;
            Intrinsics.checkNotNull((Object)metering);
            return metering;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

