/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appconfiguration.android.lib.core;

import com.ibm.appconfiguration.android.lib.core.Logger;
import com.ibm.appconfiguration.android.lib.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0014\u0018\u00010\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0004J\b\u0010$\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ibm/appconfiguration/android/lib/core/ResponseImpl;", "Lcom/ibm/appconfiguration/android/lib/core/Response;", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "bodyBytes", "", "contentType", "Lokhttp3/MediaType;", "headers", "Lokhttp3/Headers;", "okHttpResponse", "requestURL", "", "responseByteStream", "Ljava/io/InputStream;", "getContentLength", "", "getHeaders", "", "", "getInternalResponse", "getRequestURL", "getResponseByteStream", "getResponseBytes", "getResponseJSON", "Lorg/json/JSONObject;", "getResponseText", "getStatus", "", "isRedirect", "", "isSuccessful", "setResponseBytes", "", "responseBytes", "toString", "lib_release"})
public final class ResponseImpl
implements Response {
    private okhttp3.Response okHttpResponse;
    private String requestURL;
    private Headers headers;
    private MediaType contentType;
    private InputStream responseByteStream;
    private byte[] bodyBytes;

    @Override
    @Nullable
    public String getRequestURL() {
        okhttp3.Response response = this.okHttpResponse;
        return String.valueOf(response != null ? response.request() : null);
    }

    @Override
    public int getStatus() {
        int n;
        if (this.okHttpResponse == null) {
            n = 0;
        } else {
            okhttp3.Response response = this.okHttpResponse;
            Intrinsics.checkNotNull((Object)response);
            n = response.code();
        }
        return n;
    }

    @Override
    @Nullable
    public String getResponseText() {
        Object object;
        Charset charset;
        if (this.bodyBytes == null) {
            return "";
        }
        if (this.contentType != null) {
            MediaType mediaType = this.contentType;
            Intrinsics.checkNotNull((Object)mediaType);
            charset = mediaType.charset(Charsets.UTF_8);
        } else {
            charset = Charsets.UTF_8;
        }
        Charset charset2 = charset;
        try {
            String string;
            if (charset2 != null) {
                Intrinsics.checkNotNull((Object)this.bodyBytes);
                object = this.bodyBytes;
                boolean bl = false;
                string = new String((byte[])object, charset2);
            } else {
                string = "";
            }
            object = string.toString();
        }
        catch (UnsupportedEncodingException e) {
            Logger.Companion.warning("Failed to extract text from response body. Error: " + e.getMessage());
            object = null;
        }
        return object;
    }

    @Override
    @Nullable
    public JSONObject getResponseJSON() {
        CharSequence charSequence;
        String responseText;
        block5: {
            block4: {
                responseText = this.getResponseText();
                if (responseText == null) break block4;
                charSequence = responseText;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block5;
            }
            return null;
        }
        try {
            charSequence = new JSONObject(responseText);
        }
        catch (JSONException e) {
            Logger.Companion.warning("Failed to extract JSON from response body. Error: " + e.getMessage());
            charSequence = null;
        }
        return charSequence;
    }

    @Override
    @Nullable
    public byte[] getResponseBytes() {
        byte[] byArray;
        if (this.responseByteStream != null) {
            byte[] byArray2;
            try {
                InputStream inputStream = this.responseByteStream;
                Intrinsics.checkNotNull((Object)inputStream);
                byArray2 = ByteStreamsKt.readBytes((InputStream)inputStream);
            }
            catch (IOException e) {
                Logger.Companion.warning("Failed to extract byte array from response body. Error: " + e.getMessage());
                byArray2 = null;
            }
            byArray = byArray2;
        } else {
            byArray = this.bodyBytes;
        }
        return byArray;
    }

    protected final void setResponseBytes(@Nullable byte[] responseBytes) {
        this.bodyBytes = responseBytes;
    }

    @Override
    @Nullable
    public InputStream getResponseByteStream() {
        return this.responseByteStream;
    }

    public final boolean isRedirect() {
        boolean bl;
        if (this.okHttpResponse == null) {
            bl = false;
        } else {
            okhttp3.Response response = this.okHttpResponse;
            Intrinsics.checkNotNull((Object)response);
            bl = response.isRedirect();
        }
        return bl;
    }

    public final boolean isSuccessful() {
        boolean bl;
        if (this.okHttpResponse == null) {
            bl = false;
        } else {
            okhttp3.Response response = this.okHttpResponse;
            Intrinsics.checkNotNull((Object)response);
            bl = response.isSuccessful();
        }
        return bl;
    }

    @Override
    public long getContentLength() {
        long l;
        try {
            long l2;
            okhttp3.Response resp = this.getInternalResponse();
            if (resp != null) {
                ResponseBody responseBody = resp.body();
                Intrinsics.checkNotNull((Object)responseBody);
                l2 = responseBody.contentLength();
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (NullPointerException e) {
            Logger.Companion.error("Failed to get the response content length from " + this.getRequestURL() + ". Error: " + e.getMessage());
            l = 0L;
        }
        return l;
    }

    @Override
    @Nullable
    public Map<String, List<String>> getHeaders() {
        Map map;
        if (this.headers == null) {
            map = null;
        } else {
            Headers headers = this.headers;
            Intrinsics.checkNotNull((Object)headers);
            map = headers.toMultimap();
        }
        return map;
    }

    @NotNull
    public String toString() {
        String string;
        try {
            string = "Response: Status=" + this.getStatus() + ", Response Text: " + this.getResponseText();
        }
        catch (RuntimeException e) {
            string = "Response: Status= " + this.getStatus() + ", Exception occurred when constructing response text string: " + e.getLocalizedMessage();
        }
        return string;
    }

    private final okhttp3.Response getInternalResponse() {
        return this.okHttpResponse;
    }

    public ResponseImpl(@NotNull okhttp3.Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.okHttpResponse = response;
        if (this.okHttpResponse != null) {
            okhttp3.Response response2 = this.okHttpResponse;
            Intrinsics.checkNotNull((Object)response2);
            this.requestURL = response2.request().toString();
            okhttp3.Response response3 = this.okHttpResponse;
            Intrinsics.checkNotNull((Object)response3);
            this.headers = response3.headers();
            try {
                okhttp3.Response response4 = this.okHttpResponse;
                Intrinsics.checkNotNull((Object)response4);
                ResponseBody responseBody = response4.body();
                Intrinsics.checkNotNull((Object)responseBody);
                this.contentType = responseBody.contentType();
                okhttp3.Response response5 = this.okHttpResponse;
                Intrinsics.checkNotNull((Object)response5);
                ResponseBody responseBody2 = response5.body();
                Intrinsics.checkNotNull((Object)responseBody2);
                this.responseByteStream = responseBody2.byteStream();
                okhttp3.Response response6 = this.okHttpResponse;
                Intrinsics.checkNotNull((Object)response6);
                ResponseBody responseBody3 = response6.body();
                Intrinsics.checkNotNull((Object)responseBody3);
                this.bodyBytes = responseBody3.bytes();
            }
            catch (NullPointerException e) {
                Logger.Companion.error("Response body bytes can't be read: " + e.getLocalizedMessage());
                this.bodyBytes = null;
            }
            catch (IOException e) {
                Logger.Companion.error("Response body bytes can't be read: " + e.getLocalizedMessage());
                this.bodyBytes = null;
            }
        }
    }
}

