/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appconfiguration.android.lib;

import android.app.Application;
import android.content.Context;
import com.ibm.appconfiguration.android.lib.core.Logger;
import com.ibm.appconfiguration.android.lib.feature.FeatureHandler;
import com.ibm.appconfiguration.android.lib.feature.FeaturesUpdateListener;
import com.ibm.appconfiguration.android.lib.feature.internal.Validators;
import com.ibm.appconfiguration.android.lib.feature.models.Feature;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000fJ\r\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0004J\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001aJ\r\u0010\u001b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001eJ&\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/ibm/appconfiguration/android/lib/AppConfiguration;", "", "()V", "apikey", "", "application", "Landroid/app/Application;", "featureHandlerInstance", "Lcom/ibm/appconfiguration/android/lib/feature/FeatureHandler;", "guid", "isInitialized", "", "isInitializedFeature", "region", "enableDebug", "", "enable", "fetchFeatureData", "getApikey", "getApikey$lib_release", "getApplication", "getApplication$lib_release", "getFeature", "Lcom/ibm/appconfiguration/android/lib/feature/models/Feature;", "featureId", "getFeatures", "Ljava/util/HashMap;", "getGuid", "getGuid$lib_release", "getRegion", "getRegion$lib_release", "init", "registerFeaturesUpdateListener", "listener", "Lcom/ibm/appconfiguration/android/lib/feature/FeaturesUpdateListener;", "setCollectionId", "collectionId", "Companion", "lib_release"})
public final class AppConfiguration {
    private Application application;
    private String region = REGION_US_SOUTH;
    private String apikey;
    private String guid;
    private boolean isInitializedFeature;
    private boolean isInitialized;
    private FeatureHandler featureHandlerInstance;
    private static AppConfiguration instance;
    @JvmField
    @NotNull
    public static final String REGION_US_SOUTH = "us-south";
    @JvmField
    @NotNull
    public static final String REGION_EU_GB = "eu-gb";
    @JvmField
    @Nullable
    public static String overrideServerHost;
    public static final Companion Companion;

    public final void init(@NotNull Application application, @NotNull String region, @NotNull String guid, @NotNull String apikey) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        Intrinsics.checkParameterIsNotNull((Object)guid, (String)"guid");
        Intrinsics.checkParameterIsNotNull((Object)apikey, (String)"apikey");
        if (!Validators.INSTANCE.validateString(region)) {
            Logger.Companion.error("Error in initialising App Configuration SDK.Provide a valid region.");
            return;
        }
        if (!Validators.INSTANCE.validateString(guid)) {
            Logger.Companion.error("Error in initialising App Configuration SDK.Provide a valid guid.");
            return;
        }
        if (!Validators.INSTANCE.validateString(apikey)) {
            Logger.Companion.error("Error in initialising App Configuration SDK.Provide a valid apikey.");
            return;
        }
        this.apikey = apikey;
        this.application = application;
        this.region = region;
        this.guid = guid;
        this.isInitialized = true;
    }

    @Nullable
    public final Application getApplication$lib_release() {
        return this.application;
    }

    @NotNull
    public final String getRegion$lib_release() {
        return this.region;
    }

    @NotNull
    public final String getGuid$lib_release() {
        String string = this.guid;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getApikey$lib_release() {
        String string = this.apikey;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setCollectionId(@NotNull String collectionId) {
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        if (!Validators.INSTANCE.validateString(collectionId)) {
            Logger.Companion.error("Provide a valid collectionId AppConfiguration init");
            return;
        }
        if (!this.isInitialized) {
            Logger.Companion.error("Invalid action in AppConfiguration. This action can be performed only after a successful initialization. Please check the initialization section for errors.");
            return;
        }
        FeatureHandler featureHandler = this.featureHandlerInstance = FeatureHandler.Factory.getInstance();
        if (featureHandler != null) {
            Application application = this.application;
            if (application == null) {
                Intrinsics.throwNpe();
            }
            Context context = application.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"this.application!!.applicationContext");
            featureHandler.init(context, collectionId);
        }
        FeatureHandler featureHandler2 = this.featureHandlerInstance;
        if (featureHandler2 != null) {
            featureHandler2.fetchFeaturesData();
        }
        this.isInitializedFeature = true;
    }

    public final void fetchFeatureData() {
        if (this.isInitializedFeature && this.featureHandlerInstance != null) {
            FeatureHandler featureHandler = this.featureHandlerInstance;
            if (featureHandler != null) {
                featureHandler.fetchFeaturesData();
            }
        } else {
            Logger.Companion.error("Invalid action in AppConfiguration. This action can be performed only after a successful initialization and set collections ID value operation. Please check the initialization and setCollectionId sections for errors.");
        }
    }

    public final void registerFeaturesUpdateListener(@NotNull FeaturesUpdateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (this.isInitializedFeature && this.featureHandlerInstance != null) {
            FeatureHandler featureHandler = this.featureHandlerInstance;
            if (featureHandler != null) {
                featureHandler.registerFeaturesUpdateListener(listener);
            }
        } else {
            Logger.Companion.error("Invalid action in AppConfiguration. This action can be performed only after a successful initialization and set collections ID value operation. Please check the initialization and setCollectionId sections for errors.");
        }
    }

    @Nullable
    public final Feature getFeature(@NotNull String featureId) {
        Feature feature;
        Intrinsics.checkParameterIsNotNull((Object)featureId, (String)"featureId");
        if (this.isInitializedFeature && this.featureHandlerInstance != null) {
            FeatureHandler featureHandler = this.featureHandlerInstance;
            feature = featureHandler != null ? featureHandler.getFeature(featureId) : null;
        } else {
            Logger.Companion.error("Invalid action in AppConfiguration. This action can be performed only after a successful initialization and set collections ID value operation. Please check the initialization and setCollectionId sections for errors.");
            feature = null;
        }
        return feature;
    }

    @Nullable
    public final HashMap<String, Feature> getFeatures() {
        HashMap<String, Feature> hashMap;
        if (this.isInitializedFeature && this.featureHandlerInstance != null) {
            FeatureHandler featureHandler = this.featureHandlerInstance;
            hashMap = featureHandler != null ? featureHandler.getFeatures() : null;
        } else {
            Logger.Companion.error("Invalid action in AppConfiguration. This action can be performed only after a successful initialization and set collections ID value operation. Please check the initialization and setCollectionId sections for errors.");
            hashMap = null;
        }
        return hashMap;
    }

    public final void enableDebug(boolean enable) {
        Logger.Companion.setDebug(enable);
    }

    static {
        Companion = new Companion(null);
        REGION_US_SOUTH = REGION_US_SOUTH;
        REGION_EU_GB = REGION_EU_GB;
    }

    @JvmStatic
    @NotNull
    public static final AppConfiguration getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ibm/appconfiguration/android/lib/AppConfiguration$Companion;", "", "()V", "REGION_EU_GB", "", "REGION_US_SOUTH", "instance", "Lcom/ibm/appconfiguration/android/lib/AppConfiguration;", "overrideServerHost", "getInstance", "lib_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AppConfiguration getInstance() {
            if (instance == null) {
                instance = new AppConfiguration();
            }
            AppConfiguration appConfiguration = instance;
            if (appConfiguration == null) {
                Intrinsics.throwNpe();
            }
            return appConfiguration;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

