/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appconfiguration.android.lib.feature;

import android.content.Context;
import com.ibm.appconfiguration.android.lib.AppConfiguration;
import com.ibm.appconfiguration.android.lib.core.APIManager;
import com.ibm.appconfiguration.android.lib.core.BaseRequest;
import com.ibm.appconfiguration.android.lib.core.Logger;
import com.ibm.appconfiguration.android.lib.core.Response;
import com.ibm.appconfiguration.android.lib.core.ResponseListener;
import com.ibm.appconfiguration.android.lib.feature.FeaturesUpdateListener;
import com.ibm.appconfiguration.android.lib.feature.internal.FileManager;
import com.ibm.appconfiguration.android.lib.feature.internal.Metering;
import com.ibm.appconfiguration.android.lib.feature.internal.URLBuilder;
import com.ibm.appconfiguration.android.lib.feature.internal.Validators;
import com.ibm.appconfiguration.android.lib.feature.models.Feature;
import com.ibm.appconfiguration.android.lib.feature.models.internal.Segment;
import com.ibm.appconfiguration.android.lib.feature.models.internal.SegmentRules;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u001b\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\bJ\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010&\u001a\u00020\u001fH\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020(0\n2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\rJ\u000e\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/ibm/appconfiguration/android/lib/feature/FeatureHandler;", "", "()V", "appContext", "Landroid/content/Context;", "clientAttributes", "Lorg/json/JSONObject;", "collectionId", "", "featureMap", "Ljava/util/HashMap;", "Lcom/ibm/appconfiguration/android/lib/feature/models/Feature;", "featuresUpdateListener", "Lcom/ibm/appconfiguration/android/lib/feature/FeaturesUpdateListener;", "isInitialized", "", "metering", "Lcom/ibm/appconfiguration/android/lib/feature/internal/Metering;", "retryCount", "", "segmentMap", "Lcom/ibm/appconfiguration/android/lib/feature/models/internal/Segment;", "urlBuilder", "Lcom/ibm/appconfiguration/android/lib/feature/internal/URLBuilder;", "evaluateSegment", "segmentKey", "featureEvaluation", "T", "feature", "(Lcom/ibm/appconfiguration/android/lib/feature/models/Feature;)Ljava/lang/Object;", "fetchFeaturesData", "", "fetchFromAPI", "getFeature", "featureId", "getFeatures", "init", "context", "loadFeatures", "parseRules", "Lcom/ibm/appconfiguration/android/lib/feature/models/internal/SegmentRules;", "segmentRules", "Lorg/json/JSONArray;", "recordEvaluation", "registerFeaturesUpdateListener", "listener", "setClientAttributes", "attributes", "writeToFile", "jsonData", "Factory", "lib_release"})
public final class FeatureHandler {
    private String collectionId;
    private Context appContext;
    private JSONObject clientAttributes = new JSONObject();
    private FeaturesUpdateListener featuresUpdateListener;
    private boolean isInitialized;
    private URLBuilder urlBuilder;
    private HashMap<String, Feature> featureMap = new HashMap();
    private HashMap<String, Segment> segmentMap = new HashMap();
    private Metering metering;
    private int retryCount = 3;
    private static FeatureHandler instance;
    public static final Factory Factory;

    public final void init(@NotNull Context context, @NotNull String collectionId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        this.appContext = context;
        this.collectionId = collectionId;
        URLBuilder uRLBuilder = this.urlBuilder = URLBuilder.Factory.getInstance();
        if (uRLBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlBuilder");
        }
        uRLBuilder.init(collectionId);
        this.featureMap = new HashMap();
        this.segmentMap = new HashMap();
        Metering metering = this.metering = Metering.Factory.getInstance();
        if (metering != null) {
            metering.init(context);
        }
        this.isInitialized = true;
    }

    public final void registerFeaturesUpdateListener(@NotNull FeaturesUpdateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (this.isInitialized) {
            this.featuresUpdateListener = listener;
        } else {
            Logger.Companion.error("Invalid action in FeatureHandler. This action can be performed only after a successful initialization. Please check the initialization section for errors.");
        }
    }

    public final void setClientAttributes(@NotNull JSONObject attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.clientAttributes = attributes;
    }

    @Nullable
    public final HashMap<String, Feature> getFeatures() {
        return this.featureMap;
    }

    @Nullable
    public final Feature getFeature(@Nullable String featureId) {
        Feature feature;
        Map map = this.featureMap;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map2.containsKey(featureId)) {
            map = this.featureMap;
            bl = false;
            feature = (Feature)map.get(featureId);
        } else {
            this.loadFeatures();
            map = this.featureMap;
            bl = false;
            Map map3 = map;
            if (map3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map3.containsKey(featureId)) {
                map = this.featureMap;
                bl = false;
                feature = (Feature)map.get(featureId);
            } else {
                feature = null;
            }
        }
        return feature;
    }

    public final void fetchFeaturesData() {
        if (this.isInitialized) {
            this.loadFeatures();
            this.fetchFromAPI();
            this.retryCount = 3;
        }
    }

    private final void loadFeatures() {
        int i;
        int n;
        Context context = this.appContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        }
        JSONObject jSONObject = FileManager.INSTANCE.getFileData(context);
        if (jSONObject == null) {
            return;
        }
        JSONObject allFeature = jSONObject;
        if (allFeature.has("features")) {
            try {
                JSONArray jSONArray = allFeature.optJSONArray("features");
                if (jSONArray == null) {
                    return;
                }
                JSONArray allFeatureList = jSONArray;
                int n2 = 0;
                n = allFeatureList.length();
                while (n2 < n) {
                    JSONObject feature;
                    Intrinsics.checkExpressionValueIsNotNull((Object)allFeatureList.getJSONObject(i), (String)"allFeatureList.getJSONObject(i)");
                    Feature featureObj = new Feature(feature);
                    ((Map)this.featureMap).put(featureObj.getFeatureId(), featureObj);
                    ++i;
                }
            }
            catch (JSONException e) {
                Logger.Companion.error(String.valueOf(e.getMessage()));
            }
        }
        if (allFeature.has("segments")) {
            try {
                JSONArray jSONArray = allFeature.optJSONArray("segments");
                if (jSONArray == null) {
                    return;
                }
                JSONArray segmentList = jSONArray;
                n = segmentList.length();
                for (i = 0; i < n; ++i) {
                    JSONObject segment;
                    JSONObject jSONObject2 = segment = segmentList.getJSONObject(i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"segment");
                    Segment segmentObj = new Segment(jSONObject2);
                    ((Map)this.segmentMap).put(segmentObj.getSegment_id(), segmentObj);
                }
            }
            catch (JSONException e) {
                Logger.Companion.error(String.valueOf(e.getMessage()));
            }
        }
    }

    public final void recordEvaluation(@NotNull String featureId) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)featureId, (String)"featureId");
            Metering metering = this.metering;
            if (metering == null) break block1;
            String string = AppConfiguration.Companion.getInstance().getGuid$lib_release();
            String string2 = this.collectionId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"collectionId");
            }
            metering.addMetering(string, string2, featureId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T featureEvaluation(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        if (this.clientAttributes.length() <= 0) {
            return Validators.INSTANCE.convertValue(feature.getEnabled_value());
        }
        int n = 1;
        HashMap<Integer, SegmentRules> rulesMap = this.parseRules(feature.getSegmentRules());
        int n2 = rulesMap.size();
        if (n <= n2) {
            while (true) {
                void i;
                SegmentRules segmentRule;
                if ((segmentRule = rulesMap.get((int)i)) != null) {
                    int n3 = 0;
                    int n4 = segmentRule.getRules().length();
                    while (n3 < n4) {
                        void level;
                        try {
                            JSONObject rule = segmentRule.getRules().getJSONObject((int)level);
                            JSONArray segments = rule.getJSONArray("segments");
                            int n5 = 0;
                            int n6 = segments.length();
                            while (n5 < n6) {
                                void innerLevel;
                                String segmentKey;
                                String string = segmentKey = segments.getString((int)innerLevel);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"segmentKey");
                                if (this.evaluateSegment(string)) {
                                    return segmentRule.getValue() == "$default" ? Validators.INSTANCE.convertValue(feature.getEnabled_value()) : Validators.INSTANCE.convertValue(segmentRule.getValue());
                                }
                                ++innerLevel;
                            }
                        }
                        catch (JSONException e) {
                            Logger.Companion.error(String.valueOf(e.getMessage()));
                        }
                        ++level;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return Validators.INSTANCE.convertValue(feature.getEnabled_value());
    }

    private final boolean evaluateSegment(String segmentKey) {
        if (this.segmentMap.containsKey(segmentKey)) {
            Segment segment;
            Segment segment2 = segment = this.segmentMap.get(segmentKey);
            if (segment2 == null) {
                Intrinsics.throwNpe();
            }
            return segment2.evaluateRule(this.clientAttributes);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<Integer, SegmentRules> parseRules(JSONArray segmentRules) {
        HashMap<Integer, SegmentRules> rulesMap = new HashMap<Integer, SegmentRules>();
        int n = 0;
        int n2 = segmentRules.length();
        while (n < n2) {
            void i;
            try {
                JSONObject rules;
                JSONObject jSONObject = rules = segmentRules.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"rules");
                SegmentRules rulesObj = new SegmentRules(jSONObject);
                ((Map)rulesMap).put(rulesObj.getOrder(), rulesObj);
            }
            catch (JSONException e) {
                Logger.Companion.error(String.valueOf(e.getMessage()));
            }
            ++i;
        }
        return rulesMap;
    }

    public final void writeToFile(@NotNull JSONObject jsonData) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)jsonData, (String)"jsonData");
            Context context = this.appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            }
            String string = jsonData.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonData.toString()");
            FileManager.INSTANCE.storeFiles(context, string);
            this.loadFeatures();
            if (this.featuresUpdateListener == null) break block2;
            FeaturesUpdateListener featuresUpdateListener = this.featuresUpdateListener;
            if (featuresUpdateListener != null) {
                featuresUpdateListener.onFeaturesUpdate();
            }
        }
    }

    private final void fetchFromAPI() {
        if (this.isInitialized) {
            URLBuilder uRLBuilder = this.urlBuilder;
            if (uRLBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"urlBuilder");
            }
            String configURL = uRLBuilder.getConfigUrl();
            Context context = this.appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            }
            APIManager apiManager = APIManager.Companion.newInstance(context, configURL, BaseRequest.Companion.getGET());
            apiManager.setResponseListener(new ResponseListener(this){
                final /* synthetic */ FeatureHandler this$0;

                public void onSuccess(@NotNull Response response) {
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        JSONObject responseText = null;
                        try {
                            String string = response.getResponseText();
                            if (string == null) {
                                string = "";
                            }
                            responseText = new JSONObject(string);
                        }
                        catch (JSONException e) {
                            Logger.Companion.error("Error decoding the server response. " + e.getMessage());
                        }
                        JSONObject jSONObject = responseText;
                        if (jSONObject == null) break block3;
                        JSONObject jSONObject2 = jSONObject;
                        boolean bl = false;
                        boolean bl2 = false;
                        JSONObject it = jSONObject2;
                        boolean bl3 = false;
                        this.this$0.writeToFile(it);
                    }
                }

                public void onFailure(@Nullable Response response, @Nullable Throwable t, @Nullable JSONObject extendedInfo) {
                    Logger.Companion.error("Error while fetching the data from server. " + String.valueOf(extendedInfo));
                }
                {
                    this.this$0 = $outer;
                }
            });
            apiManager.execute();
        } else {
            Logger.Companion.error("fetchFromAPI() - Feature SDK not initialized with call to initialize()");
        }
    }

    static {
        Factory = new Factory(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ibm/appconfiguration/android/lib/feature/FeatureHandler$Factory;", "", "()V", "instance", "Lcom/ibm/appconfiguration/android/lib/feature/FeatureHandler;", "getInstance", "lib_release"})
    public static final class Factory {
        @NotNull
        public final FeatureHandler getInstance() {
            if (instance == null) {
                instance = new FeatureHandler();
            }
            FeatureHandler featureHandler = instance;
            if (featureHandler == null) {
                Intrinsics.throwNpe();
            }
            return featureHandler;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

