/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.ms.client;

import javax.annotation.PostConstruct;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.beetl.sql.saga.common.SagaContext;
import org.beetl.sql.saga.ms.client.SagaLevel3Context;
import org.beetl.sql.saga.ms.client.SagaLevel3ContextFactory;
import org.beetl.sql.saga.ms.client.SagaLevel3Transaction;
import org.beetl.sql.saga.ms.client.task.RollbackTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
public class SagaLevel3Config {
    private static final Logger log = LoggerFactory.getLogger(SagaLevel3Config.class);
    @Value(value="${beetlsql-saga.kafka.server-topic:saga-server-topic}")
    protected String serverTopic;
    @Value(value="${beetlsql-saga.kafka.client-topic-prefix}")
    protected String appTopic;
    @Autowired
    protected KafkaTemplate template;
    @Value(value="${spring.application.name}")
    protected String appName;

    @PostConstruct
    public void initSaga() {
        SagaContext.sagaContextFactory = new SagaLevel3ContextFactory(this);
    }

    @KafkaListener(topics={"#{'${beetlsql-saga.kafka.client-topic-prefix}'+'-'+'${spring.application.name}'}"})
    public void retry(ConsumerRecord<?, RollbackTask> record) throws Exception {
        try {
            RollbackTask task = (RollbackTask)record.value();
            SagaLevel3Context kafkaSegaContext = new SagaLevel3Context((SagaLevel3Transaction)task.getRollback(), this);
            kafkaSegaContext.realRollback();
        }
        catch (Exception ex) {
            log.info(ex.getMessage());
        }
    }

    public String getServerTopic() {
        return this.serverTopic;
    }

    public String getAppTopic() {
        return this.appTopic;
    }

    public KafkaTemplate getTemplate() {
        return this.template;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setServerTopic(String serverTopic) {
        this.serverTopic = serverTopic;
    }

    public void setAppTopic(String appTopic) {
        this.appTopic = appTopic;
    }

    public void setTemplate(KafkaTemplate template) {
        this.template = template;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaLevel3Config)) {
            return false;
        }
        SagaLevel3Config other = (SagaLevel3Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverTopic = this.getServerTopic();
        String other$serverTopic = other.getServerTopic();
        if (this$serverTopic == null ? other$serverTopic != null : !this$serverTopic.equals(other$serverTopic)) {
            return false;
        }
        String this$appTopic = this.getAppTopic();
        String other$appTopic = other.getAppTopic();
        if (this$appTopic == null ? other$appTopic != null : !this$appTopic.equals(other$appTopic)) {
            return false;
        }
        KafkaTemplate this$template = this.getTemplate();
        KafkaTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        return !(this$appName == null ? other$appName != null : !this$appName.equals(other$appName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaLevel3Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverTopic = this.getServerTopic();
        result = result * 59 + ($serverTopic == null ? 43 : $serverTopic.hashCode());
        String $appTopic = this.getAppTopic();
        result = result * 59 + ($appTopic == null ? 43 : $appTopic.hashCode());
        KafkaTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        return result;
    }

    public String toString() {
        return "SagaLevel3Config(serverTopic=" + this.getServerTopic() + ", appTopic=" + this.getAppTopic() + ", template=" + this.getTemplate() + ", appName=" + this.getAppName() + ")";
    }
}

