/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.kafka;

import org.beetl.sql.saga.common.SagaTransaction;
import org.beetl.sql.saga.kafka.SagaLevel3Config;
import org.beetl.sql.saga.kafka.task.RollbackFailureTask;
import org.beetl.sql.saga.kafka.task.RollbackInCommitTask;
import org.beetl.sql.saga.kafka.task.RollbackSuccessTask;
import org.beetl.sql.saga.kafka.task.RollbackTask;
import org.beetl.sql.saga.kafka.task.StartTask;

public class SagaServerClient {
    SagaLevel3Config level3Config;

    public SagaServerClient(SagaLevel3Config level3Config) {
        this.level3Config = level3Config;
    }

    public void start(String gid, long time) {
        StartTask startTask = new StartTask(gid, time);
        startTask.setAppName(this.level3Config.getAppName());
        this.level3Config.getTemplate().send(this.level3Config.getServerTopic(), (Object)startTask);
    }

    public void sendRollbackTask(String gid, long time, SagaTransaction tasks) {
        RollbackTask rollbackTask = new RollbackTask(gid, time, tasks);
        rollbackTask.setAppName(this.level3Config.getAppName());
        this.level3Config.getTemplate().send(this.level3Config.getServerTopic(), (Object)rollbackTask);
    }

    public void sendRollbackTaskInCommit(String gid, long time, SagaTransaction tasks) {
        RollbackInCommitTask rollbackInCommitTask = new RollbackInCommitTask(gid, time, tasks);
        rollbackInCommitTask.setAppName(this.level3Config.getAppName());
        this.level3Config.getTemplate().send(this.level3Config.getServerTopic(), (Object)rollbackInCommitTask);
    }

    public void rollbackSuccess(String gid, long time) {
        RollbackSuccessTask rollbackSuccessTask = new RollbackSuccessTask(gid, time);
        rollbackSuccessTask.setAppName(this.level3Config.getAppName());
        this.level3Config.getTemplate().send(this.level3Config.getServerTopic(), (Object)rollbackSuccessTask);
    }

    public void rollbackFailure(String gid, long time, SagaTransaction tasks) {
        RollbackFailureTask rollbackFailureTask = new RollbackFailureTask(gid, time, tasks);
        rollbackFailureTask.setAppName(this.level3Config.getAppName());
        this.level3Config.getTemplate().send(this.level3Config.getServerTopic(), (Object)rollbackFailureTask);
    }
}

