/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.kafka;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.beetl.sql.saga.common.SagaRollbackTask;
import org.beetl.sql.saga.common.SagaTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaLevel3Transaction
implements SagaTransaction {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@Clazz")
    protected List<KafkaSagaTaskTrace> tasks = new ArrayList<KafkaSagaTaskTrace>();
    protected String id = UUID.randomUUID().toString();
    protected boolean success = true;

    public String transactionId() {
        return this.id;
    }

    public void addTask(SagaRollbackTask task) {
        this.tasks.add(new KafkaSagaTaskTrace(task));
    }

    public boolean rollback() {
        for (KafkaSagaTaskTrace trace : this.tasks) {
            trace.call();
            if (trace.success) continue;
            this.success = false;
        }
        return this.success;
    }

    public List<KafkaSagaTaskTrace> getTasks() {
        return this.tasks;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setTasks(List<KafkaSagaTaskTrace> tasks) {
        this.tasks = tasks;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SagaLevel3Transaction)) {
            return false;
        }
        SagaLevel3Transaction other = (SagaLevel3Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KafkaSagaTaskTrace> this$tasks = this.getTasks();
        List<KafkaSagaTaskTrace> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        return this.isSuccess() == other.isSuccess();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SagaLevel3Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KafkaSagaTaskTrace> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SagaLevel3Transaction(tasks=" + this.getTasks() + ", id=" + this.getId() + ", success=" + this.isSuccess() + ")";
    }

    public static class KafkaSagaTaskTrace
    implements Serializable {
        private static final Logger log = LoggerFactory.getLogger(KafkaSagaTaskTrace.class);
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@Clazz")
        protected SagaRollbackTask rollbackTask = null;
        protected boolean success = false;

        public KafkaSagaTaskTrace() {
        }

        public KafkaSagaTaskTrace(SagaRollbackTask rollbackTask) {
            this.rollbackTask = rollbackTask;
        }

        public void call() {
            try {
                if (this.success) {
                    return;
                }
                this.success = this.rollbackTask.call();
                log.info("execute rollback task " + this.rollbackTask.getClass() + ":" + this.rollbackTask + " success");
            }
            catch (Exception ex) {
                log.info("execute rollback task " + this.rollbackTask.getClass() + ":" + this.rollbackTask + " failure " + ex.getMessage());
                this.success = false;
            }
        }

        public SagaRollbackTask getRollbackTask() {
            return this.rollbackTask;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setRollbackTask(SagaRollbackTask rollbackTask) {
            this.rollbackTask = rollbackTask;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KafkaSagaTaskTrace)) {
                return false;
            }
            KafkaSagaTaskTrace other = (KafkaSagaTaskTrace)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SagaRollbackTask this$rollbackTask = this.getRollbackTask();
            SagaRollbackTask other$rollbackTask = other.getRollbackTask();
            if (this$rollbackTask == null ? other$rollbackTask != null : !this$rollbackTask.equals(other$rollbackTask)) {
                return false;
            }
            return this.isSuccess() == other.isSuccess();
        }

        protected boolean canEqual(Object other) {
            return other instanceof KafkaSagaTaskTrace;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SagaRollbackTask $rollbackTask = this.getRollbackTask();
            result = result * 59 + ($rollbackTask == null ? 43 : $rollbackTask.hashCode());
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SagaLevel3Transaction.KafkaSagaTaskTrace(rollbackTask=" + this.getRollbackTask() + ", success=" + this.isSuccess() + ")";
        }
    }
}

