/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.kafka;

import java.util.concurrent.Callable;
import org.beetl.sql.saga.common.LocalSagaContext;
import org.beetl.sql.saga.common.SagaContext;
import org.beetl.sql.saga.common.SagaRollbackTask;
import org.beetl.sql.saga.common.SagaTransaction;
import org.beetl.sql.saga.kafka.SagaLevel3Config;
import org.beetl.sql.saga.kafka.SagaLevel3Transaction;
import org.beetl.sql.saga.kafka.SagaServerClient;

public class SagaLevel3Context
extends SagaContext {
    SagaLevel3Transaction transaction = null;
    SagaLevel3Config config;
    SagaServerClient client = null;

    public SagaLevel3Context(SagaLevel3Config config) {
        this.newTransaction();
        this.config = config;
        this.client = new SagaServerClient(config);
    }

    public SagaLevel3Context(SagaLevel3Transaction transaction, SagaLevel3Config config) {
        this.transaction = transaction;
        this.config = config;
        this.client = new SagaServerClient(config);
    }

    public void start() {
        throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9bgid");
    }

    public void start(String gid) {
        super.start(gid);
        try {
            this.client.start(gid, this.time);
        }
        catch (Exception ex) {
            throw new IllegalStateException("\u4e8b\u52a1\u7ba1\u7406\u5668\u4e0d\u53ef\u7528 " + ex.getMessage());
        }
        finally {
            this.clear();
        }
    }

    public void commit() {
        try {
            this.client.sendRollbackTaskInCommit(this.gid, this.time, this.transaction);
        }
        catch (Exception ex) {
            throw new IllegalStateException("\u4e8b\u52a1\u7ba1\u7406\u5668\u4e0d\u53ef\u7528 " + ex.getMessage());
        }
        finally {
            this.clear();
        }
    }

    public void rollback() {
        try {
            this.client.sendRollbackTask(this.gid, this.time, this.transaction);
        }
        catch (Exception ex) {
            throw new IllegalStateException("\u4e8b\u52a1\u7ba1\u7406\u5668\u4e0d\u53ef\u7528 " + ex.getMessage());
        }
        finally {
            this.clear();
        }
    }

    public boolean realRollback() {
        try {
            boolean success = this.transaction.rollback();
            if (success) {
                this.client.rollbackSuccess(this.gid, this.time);
                boolean bl = true;
                return bl;
            }
            this.client.rollbackFailure(this.gid, this.time, this.transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            this.clear();
        }
    }

    public SagaTransaction getTransaction() {
        return this.transaction;
    }

    protected void newTransaction() {
        this.transaction = new SagaLevel3Transaction();
    }

    protected void clear() {
        this.transaction.getTasks().clear();
        this.newTransaction();
    }

    public <T> T callService(Callable<T> callable, Runnable runnable) throws Exception {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            this.getTransaction().addTask((SagaRollbackTask)new LocalSagaContext.FunctionCallback(runnable));
            throw ex;
        }
    }
}

