/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.beetl.sql.core.kit.StringKit;

public class NumberKit {
    public static Number convertNumberToTargetClass(Number number, Class targetClass) {
        if (number == null) {
            throw new IllegalArgumentException("Number\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("TargetClass\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (Byte.class == targetClass || Byte.TYPE == targetClass) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                throw new IllegalArgumentException(number.getClass().getName() + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u76ee\u6807\u5bf9\u8c61" + targetClass.getName());
            }
            return new Byte(number.byteValue());
        }
        if (Short.class == targetClass || Short.TYPE == targetClass) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                throw new IllegalArgumentException(number.getClass().getName() + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u76ee\u6807\u5bf9\u8c61" + targetClass.getName());
            }
            return new Short(number.shortValue());
        }
        if (Integer.class == targetClass || Integer.TYPE == targetClass) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(number.getClass().getName() + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u76ee\u6807\u5bf9\u8c61" + targetClass.getName());
            }
            return new Integer(number.intValue());
        }
        if (Long.class == targetClass || Long.TYPE == targetClass) {
            BigInteger bigInt = null;
            if (number instanceof BigInteger) {
                bigInt = (BigInteger)number;
            } else if (number instanceof BigDecimal) {
                bigInt = ((BigDecimal)number).toBigInteger();
            }
            if (bigInt != null && (bigInt.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bigInt.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0)) {
                throw new IllegalArgumentException(number.getClass().getName() + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u76ee\u6807\u5bf9\u8c61" + targetClass.getName());
            }
            return new Long(number.longValue());
        }
        if (BigInteger.class == targetClass) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (Float.class == targetClass || Float.TYPE == targetClass) {
            return new Float(number.floatValue());
        }
        if (Double.class == targetClass || Double.TYPE == targetClass) {
            return new Double(number.doubleValue());
        }
        if (BigDecimal.class == targetClass) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException(number.getClass().getName() + "\u65e0\u6cd5\u8f6c\u5316\u4e3a\u76ee\u6807\u5bf9\u8c61" + targetClass.getName());
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        if (text == null) {
            throw new IllegalArgumentException("\u8f6c\u5316\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("\u671f\u671b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String trimmed = StringKit.trimAllWhitespace(text);
        if (targetClass.equals(Byte.class)) {
            return (T)(NumberKit.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (targetClass.equals(Short.class)) {
            return (T)(NumberKit.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (targetClass.equals(Integer.class)) {
            return (T)(NumberKit.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (targetClass.equals(Long.class)) {
            return (T)(NumberKit.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (targetClass.equals(BigInteger.class)) {
            return (T)(NumberKit.isHexNumber(trimmed) ? NumberKit.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u5c06[" + text + "]\u8f6c\u5316\u4e3a\u671f\u671b\u7c7b\u578b:[" + targetClass.getName() + "]");
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

