/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.ext.fn.CookieFunction;
import org.beetl.ext.web.ParameterWrapper;
import org.beetl.ext.web.SessionWrapper;
import org.beetl.ext.web.WebRenderExt;
import org.beetl.ext.web.WebVariable;

public class WebRender {
    GroupTemplate gt = null;

    public WebRender(GroupTemplate gt) {
        this.gt = gt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(String key, HttpServletRequest request, HttpServletResponse response, Object ... args) {
        Writer writer = null;
        OutputStream os = null;
        String ajaxId = null;
        Template template = null;
        boolean isError = false;
        try {
            int ajaxIdIndex = key.lastIndexOf("#");
            if (ajaxIdIndex != -1) {
                ajaxId = key.substring(ajaxIdIndex + 1);
                key = key.substring(0, ajaxIdIndex);
                template = this.gt.getAjaxTemplate(key, ajaxId);
            } else {
                template = this.gt.getTemplate(key);
            }
            Enumeration attrs = request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String attrName = (String)attrs.nextElement();
                template.binding(attrName, request.getAttribute(attrName));
            }
            WebVariable webVariable = new WebVariable();
            webVariable.setRequest(request);
            webVariable.setResponse(response);
            template.binding("session", new SessionWrapper(request, request.getSession(false)));
            template.binding("servlet", webVariable);
            template.binding("request", request);
            template.binding("ctxPath", request.getContextPath());
            template.binding("$page", new HashMap());
            template.binding("parameter", new ParameterWrapper(request));
            template.binding("cookie", new CookieFunction());
            this.modifyTemplate(template, key, request, response, args);
            String strWebAppExt = this.gt.getConf().getWebAppExt();
            if (strWebAppExt != null) {
                WebRenderExt renderExt = this.getWebRenderExt(strWebAppExt);
                renderExt.modify(template, this.gt, request, response);
            }
            if (this.gt.getConf().isDirectByteOutput()) {
                os = response.getOutputStream();
                template.renderTo(os);
            } else {
                writer = response.getWriter();
                template.renderTo(writer);
            }
        }
        catch (IOException e) {
            isError = true;
            this.handleClientError(e);
        }
        catch (BeetlException e) {
            isError = true;
            this.handleBeetlException(e);
        }
        finally {
            try {
                if (!isError && writer != null) {
                    writer.flush();
                }
                if (!isError && os != null) {
                    os.flush();
                }
            }
            catch (IOException e) {
                this.handleClientError(e);
            }
        }
    }

    protected void modifyTemplate(Template template, String key, HttpServletRequest request, HttpServletResponse response, Object ... args) {
    }

    protected void handleClientError(IOException ex) {
    }

    protected void handleBeetlException(BeetlException ex) {
        throw ex;
    }

    protected WebRenderExt getWebRenderExt(String clsName) {
        try {
            return (WebRenderExt)this.gt.getClassLoader().loadClass(clsName).newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u52a0\u8f7dWebRenderExt\u9519\u8bef\uff0c\u68c0\u67e5\u914d\u7f6e\u9879WEBAPP_EXT:" + ex.getMessage(), ex);
        }
    }
}

