/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Listener;
import org.beetl.core.engine.NodeEvent;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Statement;

public class StatementParser {
    Map<Class, Listener> listeners = new HashMap<Class, Listener>();
    BlockStatement block = null;
    Map firstNode = new HashMap(2);

    public StatementParser(Statement[] sts, GroupTemplate gt, String resourceId) {
        this.block = new BlockStatement(sts, null);
        this.firstNode.put("groupTemplate", gt);
        this.firstNode.put("resourceId", resourceId);
    }

    public void addListener(Class c, Listener ls) {
        this.listeners.put(c, ls);
    }

    public void parse() {
        Stack<Map> stack = new Stack<Map>();
        stack.push(this.firstNode);
        Class[] matchClasses = this.listeners.keySet().toArray(new Class[0]);
        this.exec(this.block, matchClasses, stack);
    }

    protected boolean match(Class astNodeType, Class[] matchClasses) {
        for (Class expected : matchClasses) {
            if (expected != astNodeType) continue;
            return true;
        }
        return false;
    }

    protected void exec(Object astNode, Class[] matchClasses, Stack stack) {
        Field[] fields;
        stack.push(astNode);
        Class<?> astNodeClass = astNode.getClass();
        for (Field f : fields = astNodeClass.getFields()) {
            if (f.getModifiers() != 1) continue;
            Class<?> target = null;
            Class<?> c = f.getType();
            target = c.isArray() ? c.getComponentType() : c;
            if (!ASTNode.class.isAssignableFrom(target)) continue;
            try {
                Object values = f.get(astNode);
                if (values == null) continue;
                Class<?> target2 = values.getClass();
                if (target2.isArray()) {
                    Object[] array = (Object[])values;
                    if (array.length == 0) continue;
                    for (int i = 0; i < array.length; ++i) {
                        Object item = array[i];
                        if (item == null) continue;
                        Class<?> target3 = item.getClass();
                        if (this.match(target3, matchClasses)) {
                            stack.push(item);
                            Listener ls = this.listeners.get(target3);
                            NodeEvent e = new NodeEvent(stack);
                            Object newASTNode = ls.onEvent(e);
                            if (newASTNode != null) {
                                stack.pop();
                                stack.push(newASTNode);
                                array[i] = newASTNode;
                                item = newASTNode;
                            }
                            this.exec(item, matchClasses, stack);
                            stack.pop();
                            continue;
                        }
                        ASTNode node = (ASTNode)item;
                        this.exec(node, matchClasses, stack);
                    }
                    continue;
                }
                if (this.match(target2, matchClasses)) {
                    stack.push(values);
                    Listener ls = this.listeners.get(target2);
                    NodeEvent e = new NodeEvent(stack);
                    Object newASTNode = ls.onEvent(e);
                    if (newASTNode != null) {
                        stack.pop();
                        stack.push(newASTNode);
                        try {
                            f.set(astNode, newASTNode);
                        }
                        catch (Exception ex) {
                            BeetlException be = new BeetlException("ERROR", "\u66ff\u6362ASTNode\u9519", ex);
                            be.pushToken(((ASTNode)newASTNode).token);
                            throw be;
                        }
                        values = newASTNode;
                    }
                    this.exec(values, matchClasses, stack);
                    stack.pop();
                    continue;
                }
                ASTNode node = (ASTNode)values;
                this.exec(node, matchClasses, stack);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        stack.pop();
    }
}

