/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Type;

public class CompareExpression
extends Expression {
    final short EQUAL = 0;
    final short NOT_EQUAL = 1;
    final short LARGE = (short)2;
    final short LARGE_EQUAL = (short)3;
    final short LESS = (short)4;
    final short LESS_EQUAL = (short)5;
    short compareMode = 0;
    public Expression a;
    public Expression b;

    public CompareExpression(Expression a, Expression b, short mode, GrammarToken token) {
        super(token);
        this.a = a;
        this.b = b;
        this.compareMode = mode;
    }

    @Override
    public Object evaluate(Context ctx) {
        Object x = this.a.evaluate(ctx);
        Object y = this.b.evaluate(ctx);
        boolean r = false;
        switch (this.compareMode) {
            case 0: {
                return ALU.equals(x, y);
            }
            case 1: {
                return !ALU.equals(x, y);
            }
            case 3: {
                return !ALU.less(x, y, this.a, this.b);
            }
            case 2: {
                return !ALU.lessEquals(x, y, this.a, this.b);
            }
            case 4: {
                return ALU.less(x, y, this.a, this.b);
            }
            case 5: {
                return ALU.lessEquals(x, y, this.a, this.b);
            }
        }
        throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f");
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.a.infer(inferCtx);
        this.b.infer(inferCtx);
        this.type = Type.BooleanType;
    }
}

