/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;
import org.beetl.core.om.ArrayAA;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.AttributeCodeGen;
import org.beetl.core.om.ListAA;
import org.beetl.core.om.MapAA;
import org.beetl.core.om.MapEntryAA;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.om.ObjectUtil;

public class AttributeAccessFactory {
    static Map<String, AttributeAccess> pojoCache = new ConcurrentHashMap<String, AttributeAccess>();
    static Map<String, AttributeAccess> generalGetCache = new ConcurrentHashMap<String, AttributeAccess>();
    public static MapAA mapAA = new MapAA();
    public static ListAA listAA = new ListAA();
    public static ArrayAA arrayAA = new ArrayAA();
    public static ObjectAA objectAA = new ObjectAA();
    public static MapEntryAA mapEntryAA = new MapEntryAA();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeAccess buildFiledAccessor(Class c, String attrExp, GroupTemplate gt) {
        if (c == Object.class) {
            return objectAA;
        }
        if (Map.class.isAssignableFrom(c)) {
            return mapAA;
        }
        if (List.class.isAssignableFrom(c)) {
            return listAA;
        }
        if (c.isArray()) {
            return arrayAA;
        }
        if (c == Map.Entry.class) {
            return mapEntryAA;
        }
        if (c.getName().startsWith("java")) {
            return objectAA;
        }
        String name = attrExp;
        String className = c + "_" + name;
        AttributeAccess aa = pojoCache.get(className);
        if (aa != null) {
            return aa;
        }
        FindResult pojoResult = AttributeAccessFactory.findCommonInterfaceOrClass(c, name);
        if (pojoResult != null) {
            if (!pojoResult.realMethodName.equals("get")) {
                className = pojoResult.c + "_" + name;
                aa = pojoCache.get(className);
                if (aa != null) {
                    return aa;
                }
                Class clazz = pojoResult.c;
                synchronized (clazz) {
                    aa = pojoCache.get(className);
                    if (aa != null) {
                        return aa;
                    }
                    aa = AttributeCodeGen.createAAClass(pojoResult.c, name, pojoResult.realMethodName, pojoResult.returnType, gt);
                    pojoCache.put(className, aa);
                    return aa;
                }
            }
            className = c + "_get";
            aa = generalGetCache.get(className);
            if (aa != null) {
                return aa;
            }
            Class clazz = c;
            synchronized (clazz) {
                aa = generalGetCache.get(className);
                if (aa != null) {
                    return aa;
                }
                aa = AttributeCodeGen.createAAClass(c, "get", "get", pojoResult.returnType, pojoResult.parameter, gt);
                generalGetCache.put(className, aa);
                return aa;
            }
        }
        return objectAA;
    }

    public static FindResult findCommonInterfaceOrClass(Class c, String name) {
        Method m = ObjectUtil.getInvokder(c, name).getMethod();
        String methodName = m.getName();
        if (methodName.equals("get")) {
            FindResult findResult = new FindResult();
            findResult.parameter = m.getParameterTypes()[0];
            findResult.realMethodName = "get";
            findResult.c = c;
            findResult.returnType = m.getReturnType();
            return findResult;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            FindResult result = new FindResult();
            result.realMethodName = m.getName();
            result.c = c;
            result.returnType = m.getReturnType();
            Class<?>[] para = m.getParameterTypes();
            result.parameter = para.length == 0 ? null : para[1];
            return result;
        }
        FindResult findResult = AttributeAccessFactory.findResult(c, methodName);
        return findResult;
    }

    private static FindResult findResult(Class c, String getName) {
        Class<?>[] interfaces;
        FindResult result = null;
        Method[] methods = c.getMethods();
        Method findMethod = null;
        for (Method m : methods) {
            String name = m.getName();
            Class<?>[] paras = m.getParameterTypes();
            if (paras.length != 0 || !name.equals(getName)) continue;
            findMethod = m;
            break;
        }
        if (findMethod != null && Modifier.isPublic(c.getModifiers())) {
            result = new FindResult();
            result.realMethodName = findMethod.getName();
            result.c = c;
            result.returnType = findMethod.getReturnType();
            Class<?>[] para = findMethod.getParameterTypes();
            result.parameter = para.length == 0 ? null : para[1];
            return result;
        }
        for (Class<?> inc : interfaces = c.getInterfaces()) {
            if (!Modifier.isPublic(inc.getModifiers()) || inc.getName().startsWith("java.") || (result = AttributeAccessFactory.findResult(inc, getName)) == null) continue;
            return result;
        }
        Class parent = c.getSuperclass();
        if (parent != null && Modifier.isPublic(parent.getModifiers()) && !parent.getName().startsWith("java.") && (result = AttributeAccessFactory.findResult(parent, getName)) != null) {
            return result;
        }
        return null;
    }

    private static void resetFindResult(Method m, FindResult parent) {
    }

    static class FindResult {
        String realMethodName;
        Class c;
        Class returnType;
        Class parameter;

        FindResult() {
        }
    }
}

