/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.misc;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;

public class ClassSearch {
    Set<String> pkgList;
    Map<String, Class> map = new ConcurrentHashMap<String, Class>();
    GroupTemplate gt;

    public ClassSearch(Set<String> pkgList, GroupTemplate gt) {
        this.pkgList = pkgList;
        this.gt = gt;
    }

    public Class getClassByName(String name) {
        if (name.indexOf(".") != -1) {
            try {
                return Class.forName(name, true, this.gt.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Class<?> cls = this.map.get(name);
        if (cls == null) {
            for (String pkg : this.pkgList) {
                try {
                    String clsName = pkg.concat(name);
                    cls = Class.forName(clsName, true, this.gt.getClassLoader());
                    this.map.put(name, cls);
                    return cls;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
        return cls;
    }
}

