/*
 * Decompiled with CFR 0.152.
 */
package com.iarcuschin.simpleratingbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.BounceInterpolator;
import android.view.animation.Interpolator;
import com.iarcuschin.simpleratingbar.R;

public class SimpleRatingBar
extends View {
    @ColorInt
    private int borderColor;
    @ColorInt
    private int fillColor;
    @ColorInt
    private int backgroundColor;
    @ColorInt
    private int starBackgroundColor;
    @ColorInt
    private int pressedBorderColor;
    @ColorInt
    private int pressedFillColor;
    @ColorInt
    private int pressedBackgroundColor;
    @ColorInt
    private int pressedStarBackgroundColor;
    private int numberOfStars;
    private float starsSeparation;
    private float desiredStarSize;
    private float maxStarSize;
    private float stepSize;
    private float rating;
    private boolean isIndicator;
    private Gravity gravity;
    private float starBorderWidth;
    private float starCornerRadius;
    private boolean drawBorderEnabled;
    private float currentStarSize;
    private float defaultStarSize;
    private Paint paintStarOutline;
    private Paint paintStarBorder;
    private Paint paintStarFill;
    private Paint paintStarBackground;
    private CornerPathEffect cornerPathEffect;
    private Path starPath;
    private ValueAnimator ratingAnimator;
    private OnRatingBarChangeListener listener;
    private boolean touchInProgress;
    private float[] starVertex;
    private RectF starsDrawingSpace;
    private RectF starsTouchSpace;
    private Canvas internalCanvas;
    private Bitmap internalBitmap;

    public SimpleRatingBar(Context context) {
        super(context);
        this.initView();
    }

    public SimpleRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttrs(attrs);
        this.initView();
    }

    public SimpleRatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttrs(attrs);
        this.initView();
    }

    private void initView() {
        this.starPath = new Path();
        this.cornerPathEffect = new CornerPathEffect(this.starCornerRadius);
        this.paintStarOutline = new Paint(5);
        this.paintStarOutline.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintStarOutline.setAntiAlias(true);
        this.paintStarOutline.setDither(true);
        this.paintStarOutline.setStrokeJoin(Paint.Join.ROUND);
        this.paintStarOutline.setStrokeCap(Paint.Cap.ROUND);
        this.paintStarOutline.setColor(-16777216);
        this.paintStarOutline.setPathEffect((PathEffect)this.cornerPathEffect);
        this.paintStarBorder = new Paint(5);
        this.paintStarBorder.setStyle(Paint.Style.STROKE);
        this.paintStarBorder.setStrokeJoin(Paint.Join.ROUND);
        this.paintStarBorder.setStrokeCap(Paint.Cap.ROUND);
        this.paintStarBorder.setStrokeWidth(this.starBorderWidth);
        this.paintStarBorder.setPathEffect((PathEffect)this.cornerPathEffect);
        this.paintStarBackground = new Paint(5);
        this.paintStarBackground.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintStarBackground.setAntiAlias(true);
        this.paintStarBackground.setDither(true);
        this.paintStarBackground.setStrokeJoin(Paint.Join.ROUND);
        this.paintStarBackground.setStrokeCap(Paint.Cap.ROUND);
        this.paintStarFill = new Paint(5);
        this.paintStarFill.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintStarFill.setAntiAlias(true);
        this.paintStarFill.setDither(true);
        this.paintStarFill.setStrokeJoin(Paint.Join.ROUND);
        this.paintStarFill.setStrokeCap(Paint.Cap.ROUND);
        this.defaultStarSize = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private void parseAttrs(AttributeSet attrs) {
        TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.SimpleRatingBar);
        this.borderColor = arr.getColor(R.styleable.SimpleRatingBar_srb_borderColor, this.getResources().getColor(R.color.golden_stars));
        this.fillColor = arr.getColor(R.styleable.SimpleRatingBar_srb_fillColor, this.borderColor);
        this.starBackgroundColor = arr.getColor(R.styleable.SimpleRatingBar_srb_starBackgroundColor, 0);
        this.backgroundColor = arr.getColor(R.styleable.SimpleRatingBar_srb_backgroundColor, 0);
        this.pressedBorderColor = arr.getColor(R.styleable.SimpleRatingBar_srb_pressedBorderColor, this.borderColor);
        this.pressedFillColor = arr.getColor(R.styleable.SimpleRatingBar_srb_pressedFillColor, this.fillColor);
        this.pressedStarBackgroundColor = arr.getColor(R.styleable.SimpleRatingBar_srb_pressedStarBackgroundColor, this.starBackgroundColor);
        this.pressedBackgroundColor = arr.getColor(R.styleable.SimpleRatingBar_srb_pressedBackgroundColor, this.backgroundColor);
        this.numberOfStars = arr.getInteger(R.styleable.SimpleRatingBar_srb_numberOfStars, 5);
        float starsSeparationDp = arr.getDimension(R.styleable.SimpleRatingBar_srb_starsSeparation, 4.0f);
        this.starsSeparation = TypedValue.applyDimension((int)1, (float)starsSeparationDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.maxStarSize = arr.getDimensionPixelSize(R.styleable.SimpleRatingBar_srb_maxStarSize, Integer.MAX_VALUE);
        this.desiredStarSize = arr.getDimensionPixelSize(R.styleable.SimpleRatingBar_srb_starSize, Integer.MAX_VALUE);
        this.stepSize = arr.getFloat(R.styleable.SimpleRatingBar_srb_stepSize, Float.MAX_VALUE);
        this.starBorderWidth = arr.getFloat(R.styleable.SimpleRatingBar_srb_starBorderWidth, 5.0f);
        this.starCornerRadius = arr.getFloat(R.styleable.SimpleRatingBar_srb_starCornerRadius, 6.0f);
        this.rating = this.normalizeRating(arr.getFloat(R.styleable.SimpleRatingBar_srb_rating, 0.0f));
        this.isIndicator = arr.getBoolean(R.styleable.SimpleRatingBar_srb_isIndicator, false);
        this.drawBorderEnabled = arr.getBoolean(R.styleable.SimpleRatingBar_srb_drawBorderEnabled, true);
        this.gravity = Gravity.fromId(arr.getInt(R.styleable.SimpleRatingBar_srb_gravity, Gravity.Left.id));
        arr.recycle();
        this.validateAttrs();
    }

    private void validateAttrs() {
        if (this.numberOfStars <= 0) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for numberOfStars. Found %d, but should be greater than 0", this.numberOfStars));
        }
        if (this.desiredStarSize != 2.1474836E9f && this.maxStarSize != 2.1474836E9f && this.desiredStarSize > this.maxStarSize) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Initialized with conflicting values: starSize is greater than maxStarSize (%f > %f). I will ignore maxStarSize", Float.valueOf(this.desiredStarSize), Float.valueOf(this.maxStarSize)));
        }
        if (this.stepSize <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for stepSize. Found %f, but should be greater than 0", Float.valueOf(this.stepSize)));
        }
        if (this.starBorderWidth <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starBorderWidth. Found %f, but should be greater than 0", Float.valueOf(this.starBorderWidth)));
        }
        if (this.starCornerRadius < 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starCornerRadius. Found %f, but should be greater or equal than 0", Float.valueOf(this.starBorderWidth)));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int desiredWidth;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            if (this.desiredStarSize != 2.1474836E9f) {
                desiredWidth = this.calculateTotalWidth(this.desiredStarSize, this.numberOfStars, this.starsSeparation, true);
                width = Math.min(desiredWidth, widthSize);
            } else if (this.maxStarSize != 2.1474836E9f) {
                desiredWidth = this.calculateTotalWidth(this.maxStarSize, this.numberOfStars, this.starsSeparation, true);
                width = Math.min(desiredWidth, widthSize);
            } else {
                desiredWidth = this.calculateTotalWidth(this.defaultStarSize, this.numberOfStars, this.starsSeparation, true);
                width = Math.min(desiredWidth, widthSize);
            }
        } else {
            width = this.desiredStarSize != 2.1474836E9f ? (desiredWidth = this.calculateTotalWidth(this.desiredStarSize, this.numberOfStars, this.starsSeparation, true)) : (this.maxStarSize != 2.1474836E9f ? (desiredWidth = this.calculateTotalWidth(this.maxStarSize, this.numberOfStars, this.starsSeparation, true)) : (desiredWidth = this.calculateTotalWidth(this.defaultStarSize, this.numberOfStars, this.starsSeparation, true)));
        }
        float tentativeStarSize = ((float)(width - this.getPaddingLeft() - this.getPaddingRight()) - this.starsSeparation * (float)(this.numberOfStars - 1)) / (float)this.numberOfStars;
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            if (this.desiredStarSize != 2.1474836E9f) {
                int desiredHeight = this.calculateTotalHeight(this.desiredStarSize, this.numberOfStars, this.starsSeparation, true);
                height = Math.min(desiredHeight, heightSize);
            } else if (this.maxStarSize != 2.1474836E9f) {
                int desiredHeight = this.calculateTotalHeight(this.maxStarSize, this.numberOfStars, this.starsSeparation, true);
                height = Math.min(desiredHeight, heightSize);
            } else {
                int desiredHeight = this.calculateTotalHeight(tentativeStarSize, this.numberOfStars, this.starsSeparation, true);
                height = Math.min(desiredHeight, heightSize);
            }
        } else {
            int desiredHeight;
            height = this.desiredStarSize != 2.1474836E9f ? (desiredHeight = this.calculateTotalHeight(this.desiredStarSize, this.numberOfStars, this.starsSeparation, true)) : (this.maxStarSize != 2.1474836E9f ? (desiredHeight = this.calculateTotalHeight(this.maxStarSize, this.numberOfStars, this.starsSeparation, true)) : (desiredHeight = this.calculateTotalHeight(tentativeStarSize, this.numberOfStars, this.starsSeparation, true)));
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = this.getWidth();
        int height = this.getHeight();
        this.currentStarSize = this.desiredStarSize == 2.1474836E9f ? this.calculateBestStarSize(width, height) : this.desiredStarSize;
        this.performStarSizeAssociatedCalculations(width, height);
    }

    private float calculateBestStarSize(int width, int height) {
        if (this.maxStarSize != 2.1474836E9f) {
            float desiredTotalWidth = this.calculateTotalWidth(this.maxStarSize, this.numberOfStars, this.starsSeparation, true);
            float desiredTotalHeight = this.calculateTotalHeight(this.maxStarSize, this.numberOfStars, this.starsSeparation, true);
            if (desiredTotalWidth >= (float)width || desiredTotalHeight >= (float)height) {
                float sizeBasedOnWidth = ((float)(width - this.getPaddingLeft() - this.getPaddingRight()) - this.starsSeparation * (float)(this.numberOfStars - 1)) / (float)this.numberOfStars;
                float sizeBasedOnHeight = height - this.getPaddingTop() - this.getPaddingBottom();
                return Math.min(sizeBasedOnWidth, sizeBasedOnHeight);
            }
            return this.maxStarSize;
        }
        float sizeBasedOnWidth = ((float)(width - this.getPaddingLeft() - this.getPaddingRight()) - this.starsSeparation * (float)(this.numberOfStars - 1)) / (float)this.numberOfStars;
        float sizeBasedOnHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        return Math.min(sizeBasedOnWidth, sizeBasedOnHeight);
    }

    private void performStarSizeAssociatedCalculations(int width, int height) {
        float totalStarsWidth = this.calculateTotalWidth(this.currentStarSize, this.numberOfStars, this.starsSeparation, false);
        float totalStarsHeight = this.calculateTotalHeight(this.currentStarSize, this.numberOfStars, this.starsSeparation, false);
        float startingX = (float)((width - this.getPaddingLeft() - this.getPaddingRight()) / 2) - totalStarsWidth / 2.0f + (float)this.getPaddingLeft();
        float startingY = (float)((height - this.getPaddingTop() - this.getPaddingBottom()) / 2) - totalStarsHeight / 2.0f + (float)this.getPaddingTop();
        this.starsDrawingSpace = new RectF(startingX, startingY, startingX + totalStarsWidth, startingY + totalStarsHeight);
        float aux = this.starsDrawingSpace.width() * 0.05f;
        this.starsTouchSpace = new RectF(this.starsDrawingSpace.left - aux, this.starsDrawingSpace.top, this.starsDrawingSpace.right + aux, this.starsDrawingSpace.bottom);
        float bottomFromMargin = this.currentStarSize * 0.2f;
        float triangleSide = this.currentStarSize * 0.35f;
        float half = this.currentStarSize * 0.5f;
        float tipVerticalMargin = this.currentStarSize * 0.05f;
        float tipHorizontalMargin = this.currentStarSize * 0.03f;
        float innerUpHorizontalMargin = this.currentStarSize * 0.38f;
        float innerBottomHorizontalMargin = this.currentStarSize * 0.32f;
        float innerBottomVerticalMargin = this.currentStarSize * 0.55f;
        float innerCenterVerticalMargin = this.currentStarSize * 0.27f;
        this.starVertex = new float[]{tipHorizontalMargin, innerUpHorizontalMargin, tipHorizontalMargin + triangleSide, innerUpHorizontalMargin, half, tipVerticalMargin, this.currentStarSize - tipHorizontalMargin - triangleSide, innerUpHorizontalMargin, this.currentStarSize - tipHorizontalMargin, innerUpHorizontalMargin, this.currentStarSize - innerBottomHorizontalMargin, innerBottomVerticalMargin, this.currentStarSize - bottomFromMargin, this.currentStarSize - tipVerticalMargin, half, this.currentStarSize - innerCenterVerticalMargin, bottomFromMargin, this.currentStarSize - tipVerticalMargin, innerBottomHorizontalMargin, innerBottomVerticalMargin};
    }

    private int calculateTotalWidth(float starSize, int numberOfStars, float starsSeparation, boolean padding) {
        return Math.round(starSize * (float)numberOfStars + starsSeparation * (float)(numberOfStars - 1)) + (padding ? this.getPaddingLeft() + this.getPaddingRight() : 0);
    }

    private int calculateTotalHeight(float starSize, int numberOfStars, float starsSeparation, boolean padding) {
        return Math.round(starSize) + (padding ? this.getPaddingTop() + this.getPaddingBottom() : 0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.generateInternalCanvas(w, h);
    }

    private void generateInternalCanvas(int w, int h) {
        if (this.internalBitmap != null) {
            this.internalBitmap.recycle();
        }
        if (w > 0 && h > 0) {
            this.internalBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.internalBitmap.eraseColor(0);
            this.internalCanvas = new Canvas(this.internalBitmap);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = this.getHeight();
        int width = this.getWidth();
        if (width == 0 || height == 0) {
            return;
        }
        this.internalCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.setupColorsInPaint();
        if (this.gravity == Gravity.Left) {
            this.drawFromLeftToRight(this.internalCanvas);
        } else {
            this.drawFromRightToLeft(this.internalCanvas);
        }
        if (this.touchInProgress) {
            canvas.drawColor(this.pressedBackgroundColor);
        } else {
            canvas.drawColor(this.backgroundColor);
        }
        canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, null);
    }

    private void setupColorsInPaint() {
        if (this.touchInProgress) {
            this.paintStarBorder.setColor(this.pressedBorderColor);
            this.paintStarFill.setColor(this.pressedFillColor);
            if (this.pressedFillColor != 0) {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            this.paintStarBackground.setColor(this.pressedStarBackgroundColor);
            if (this.pressedStarBackgroundColor != 0) {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
        } else {
            this.paintStarBorder.setColor(this.borderColor);
            this.paintStarFill.setColor(this.fillColor);
            if (this.fillColor != 0) {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            this.paintStarBackground.setColor(this.starBackgroundColor);
            if (this.starBackgroundColor != 0) {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
        }
    }

    private void drawFromLeftToRight(Canvas internalCanvas) {
        float remainingTotalRating = this.getRatingToDraw();
        float startingX = this.starsDrawingSpace.left;
        float startingY = this.starsDrawingSpace.top;
        for (int i = 0; i < this.numberOfStars; ++i) {
            if (remainingTotalRating >= 1.0f) {
                this.drawStar(internalCanvas, startingX, startingY, 1.0f, Gravity.Left);
                remainingTotalRating -= 1.0f;
            } else {
                this.drawStar(internalCanvas, startingX, startingY, remainingTotalRating, Gravity.Left);
                remainingTotalRating = 0.0f;
            }
            startingX += this.starsSeparation + this.currentStarSize;
        }
    }

    private void drawFromRightToLeft(Canvas internalCanvas) {
        float remainingTotalRating = this.getRatingToDraw();
        float startingX = this.starsDrawingSpace.right - this.currentStarSize;
        float startingY = this.starsDrawingSpace.top;
        for (int i = 0; i < this.numberOfStars; ++i) {
            if (remainingTotalRating >= 1.0f) {
                this.drawStar(internalCanvas, startingX, startingY, 1.0f, Gravity.Right);
                remainingTotalRating -= 1.0f;
            } else {
                this.drawStar(internalCanvas, startingX, startingY, remainingTotalRating, Gravity.Right);
                remainingTotalRating = 0.0f;
            }
            startingX -= this.starsSeparation + this.currentStarSize;
        }
    }

    private float getRatingToDraw() {
        if (this.stepSize != Float.MAX_VALUE) {
            if (this.rating >= (float)this.numberOfStars) {
                return this.numberOfStars;
            }
            return this.rating - this.rating % this.stepSize;
        }
        return this.rating;
    }

    private void drawStar(Canvas canvas, float x, float y, float filled, Gravity gravity) {
        float fill = this.currentStarSize * filled;
        this.starPath.reset();
        this.starPath.moveTo(x + this.starVertex[0], y + this.starVertex[1]);
        for (int i = 2; i < this.starVertex.length; i += 2) {
            this.starPath.lineTo(x + this.starVertex[i], y + this.starVertex[i + 1]);
        }
        this.starPath.close();
        canvas.drawPath(this.starPath, this.paintStarOutline);
        if (gravity == Gravity.Left) {
            canvas.drawRect(x, y, x + fill + this.currentStarSize * 0.02f, y + this.currentStarSize, this.paintStarFill);
            canvas.drawRect(x + fill, y, x + this.currentStarSize, y + this.currentStarSize, this.paintStarBackground);
        } else {
            canvas.drawRect(x + this.currentStarSize - (fill + this.currentStarSize * 0.02f), y, x + this.currentStarSize, y + this.currentStarSize, this.paintStarFill);
            canvas.drawRect(x, y, x + this.currentStarSize - fill, y + this.currentStarSize, this.paintStarBackground);
        }
        if (this.drawBorderEnabled) {
            canvas.drawPath(this.starPath, this.paintStarBorder);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isIndicator || this.ratingAnimator != null && this.ratingAnimator.isRunning()) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 0: 
            case 2: {
                if (this.starsTouchSpace.contains(event.getX(), event.getY())) {
                    this.touchInProgress = true;
                    this.setNewRatingFromTouch(event.getX(), event.getY());
                    break;
                }
                if (this.touchInProgress && this.listener != null) {
                    this.listener.onRatingChanged(this, this.rating, true);
                }
                this.touchInProgress = false;
                return false;
            }
            case 1: {
                this.setNewRatingFromTouch(event.getX(), event.getY());
            }
            case 3: {
                if (this.listener != null) {
                    this.listener.onRatingChanged(this, this.rating, true);
                }
                this.touchInProgress = false;
            }
        }
        this.invalidate();
        return true;
    }

    private void setNewRatingFromTouch(float x, float y) {
        if (this.gravity != Gravity.Left) {
            x = (float)this.getWidth() - x;
        }
        if (x < this.starsDrawingSpace.left) {
            this.rating = 0.0f;
            return;
        }
        if (x > this.starsDrawingSpace.right) {
            this.rating = this.numberOfStars;
            return;
        }
        this.rating = (float)this.numberOfStars / this.starsDrawingSpace.width() * (x -= this.starsDrawingSpace.left);
        if (this.stepSize != Float.MAX_VALUE) {
            float mod = this.rating % this.stepSize;
            if (mod < this.stepSize / 4.0f) {
                this.rating -= mod;
                this.rating = Math.max(0.0f, this.rating);
            } else {
                this.rating = this.rating - mod + this.stepSize;
                this.rating = Math.min((float)this.numberOfStars, this.rating);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.rating = this.getRating();
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setRating(savedState.rating);
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = this.normalizeRating(rating);
        if (!(this.stepSize == Float.MAX_VALUE || this.ratingAnimator != null && this.ratingAnimator.isRunning())) {
            rating -= rating % this.stepSize;
        }
        this.invalidate();
        if (!(this.listener == null || this.ratingAnimator != null && this.ratingAnimator.isRunning())) {
            this.listener.onRatingChanged(this, rating, false);
        }
    }

    public boolean isIndicator() {
        return this.isIndicator;
    }

    public void setIndicator(boolean indicator) {
        this.isIndicator = indicator;
        this.touchInProgress = false;
    }

    public float getMaxStarSize() {
        return this.maxStarSize;
    }

    public void setMaxStarSize(float maxStarSize) {
        this.maxStarSize = maxStarSize;
        if (this.currentStarSize > maxStarSize) {
            this.requestLayout();
            this.generateInternalCanvas(this.getWidth(), this.getHeight());
            this.invalidate();
        }
    }

    public float getStarSize() {
        return this.currentStarSize;
    }

    public void setStarSize(float starSize) {
        this.desiredStarSize = starSize;
        if (starSize != 2.1474836E9f && this.maxStarSize != 2.1474836E9f && starSize > this.maxStarSize) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Initialized with conflicting values: starSize is greater than maxStarSize (%f > %f). I will ignore maxStarSize", Float.valueOf(starSize), Float.valueOf(this.maxStarSize)));
        }
        this.requestLayout();
        this.generateInternalCanvas(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for stepSize. Found %f, but should be greater than 0", Float.valueOf(stepSize)));
        }
        this.invalidate();
    }

    public float getStarsSeparation() {
        return this.starsSeparation;
    }

    public void setStarsSeparation(float starsSeparation) {
        this.starsSeparation = starsSeparation;
        this.requestLayout();
        this.generateInternalCanvas(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public int getNumberOfStars() {
        return this.numberOfStars;
    }

    public void setNumberOfStars(int numberOfStars) {
        this.numberOfStars = numberOfStars;
        if (numberOfStars <= 0) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for numberOfStars. Found %d, but should be greater than 0", numberOfStars));
        }
        this.rating = 0.0f;
        this.requestLayout();
        this.generateInternalCanvas(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public float getStarBorderWidth() {
        return this.starBorderWidth;
    }

    public void setStarBorderWidth(float starBorderWidth) {
        this.starBorderWidth = starBorderWidth;
        if (starBorderWidth <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starBorderWidth. Found %f, but should be greater than 0", Float.valueOf(starBorderWidth)));
        }
        this.paintStarBorder.setStrokeWidth(starBorderWidth);
        this.invalidate();
    }

    public float getStarCornerRadius() {
        return this.starCornerRadius;
    }

    public void setStarCornerRadius(float starCornerRadius) {
        this.starCornerRadius = starCornerRadius;
        if (starCornerRadius < 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starCornerRadius. Found %f, but should be greater or equal than 0", Float.valueOf(starCornerRadius)));
        }
        this.cornerPathEffect = new CornerPathEffect(starCornerRadius);
        this.paintStarBorder.setPathEffect((PathEffect)this.cornerPathEffect);
        this.paintStarOutline.setPathEffect((PathEffect)this.cornerPathEffect);
        this.invalidate();
    }

    @ColorInt
    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    @ColorInt
    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(@ColorInt int fillColor) {
        this.fillColor = fillColor;
        this.invalidate();
    }

    @ColorInt
    public int getStarBackgroundColor() {
        return this.starBackgroundColor;
    }

    public void setStarBackgroundColor(@ColorInt int starBackgroundColor) {
        this.starBackgroundColor = starBackgroundColor;
        this.invalidate();
    }

    @ColorInt
    public int getPressedBorderColor() {
        return this.pressedBorderColor;
    }

    public void setPressedBorderColor(@ColorInt int pressedBorderColor) {
        this.pressedBorderColor = pressedBorderColor;
        this.invalidate();
    }

    @ColorInt
    public int getPressedFillColor() {
        return this.pressedFillColor;
    }

    public void setPressedFillColor(@ColorInt int pressedFillColor) {
        this.pressedFillColor = pressedFillColor;
        this.invalidate();
    }

    @ColorInt
    public int getPressedStarBackgroundColor() {
        return this.pressedStarBackgroundColor;
    }

    public void setPressedStarBackgroundColor(@ColorInt int pressedStarBackgroundColor) {
        this.pressedStarBackgroundColor = pressedStarBackgroundColor;
        this.invalidate();
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    public boolean isDrawBorderEnabled() {
        return this.drawBorderEnabled;
    }

    public void setDrawBorderEnabled(boolean drawBorderEnabled) {
        this.drawBorderEnabled = drawBorderEnabled;
        this.invalidate();
    }

    private void animateRating(AnimationBuilder builder) {
        builder.ratingTarget = this.normalizeRating(builder.ratingTarget);
        this.ratingAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, builder.ratingTarget});
        this.ratingAnimator.setDuration(builder.duration);
        this.ratingAnimator.setRepeatCount(builder.repeatCount);
        this.ratingAnimator.setRepeatMode(builder.repeatMode);
        this.ratingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                SimpleRatingBar.this.setRating(value);
            }
        });
        if (builder.interpolator != null) {
            this.ratingAnimator.setInterpolator((TimeInterpolator)builder.interpolator);
        }
        if (builder.animatorListener != null) {
            this.ratingAnimator.addListener(builder.animatorListener);
        }
        this.ratingAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }

            public void onAnimationCancel(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }

            public void onAnimationRepeat(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }
        });
        this.ratingAnimator.start();
    }

    public AnimationBuilder getAnimationBuilder() {
        return new AnimationBuilder(this);
    }

    private float normalizeRating(float rating) {
        if (rating < 0.0f) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Assigned rating is less than 0 (%f < 0), I will set it to exactly 0", Float.valueOf(rating)));
            return 0.0f;
        }
        if (rating > (float)this.numberOfStars) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Assigned rating is greater than numberOfStars (%f > %d), I will set it to exactly numberOfStars", Float.valueOf(rating), this.numberOfStars));
            return this.numberOfStars;
        }
        return rating;
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.listener = listener;
    }

    public class AnimationBuilder {
        private SimpleRatingBar ratingBar;
        private long duration;
        private Interpolator interpolator;
        private float ratingTarget;
        private int repeatCount;
        private int repeatMode;
        private Animator.AnimatorListener animatorListener;

        private AnimationBuilder(SimpleRatingBar ratingBar) {
            this.ratingBar = ratingBar;
            this.duration = 2000L;
            this.interpolator = new BounceInterpolator();
            this.ratingTarget = ratingBar.getNumberOfStars();
            this.repeatCount = 1;
            this.repeatMode = 2;
        }

        public AnimationBuilder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationBuilder setInterpolator(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public AnimationBuilder setRatingTarget(float ratingTarget) {
            this.ratingTarget = ratingTarget;
            return this;
        }

        public AnimationBuilder setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public AnimationBuilder setRepeatMode(int repeatMode) {
            this.repeatMode = repeatMode;
            return this;
        }

        public AnimationBuilder setAnimatorListener(Animator.AnimatorListener animatorListener) {
            this.animatorListener = animatorListener;
            return this;
        }

        public void start() {
            this.ratingBar.animateRating(this);
        }
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(SimpleRatingBar var1, float var2, boolean var3);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private float rating = 0.0f;

        protected SavedState(Parcel source) {
            super(source);
            this.rating = source.readFloat();
        }

        @TargetApi(value=24)
        protected SavedState(Parcel source, ClassLoader loader) {
            super(source, loader);
        }

        protected SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.rating);
        }
    }

    public static enum Gravity {
        Left(0),
        Right(1);

        int id;

        private Gravity(int id) {
            this.id = id;
        }

        static Gravity fromId(int id) {
            for (Gravity f : Gravity.values()) {
                if (f.id != id) continue;
                return f;
            }
            Log.w((String)"SimpleRatingBar", (String)String.format("Gravity chosen is neither 'left' nor 'right', I will set it to Left", new Object[0]));
            return Left;
        }
    }
}

