/*
 * Decompiled with CFR 0.152.
 */
package com.iamhabib.ratingrequestlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.iamhabib.ratingrequestlibrary.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class RatingRequest {
    public static Builder with(Context context) {
        return new Builder(context);
    }

    public static interface ClickListener {
        public void onAgreeButtonClick();

        public void onDoneButtonClick();

        public void onLaterButtonClick();
    }

    public static class Builder {
        private Button btn_agree;
        private Button btn_done;
        private Button btn_later;
        SharedPreferences settings;
        ClickListener listener;
        Context context;
        private static long delayTime = 1000L;
        private static int scheduleAfter = 5;
        private boolean isCancelable = true;
        View v;
        static Handler dismissHandler = new Handler();
        static Runnable dialogRunnable;

        public Builder(Context context) {
            this.context = context;
            this.v = LayoutInflater.from((Context)context).inflate(R.layout.dialog_view, null);
            this.btn_agree = (Button)this.v.findViewById(R.id.btn_yes);
            this.btn_done = (Button)this.v.findViewById(R.id.btn_done);
            this.btn_later = (Button)this.v.findViewById(R.id.btn_later);
            this.settings = context.getSharedPreferences("ReviewDialogPref", 0);
        }

        private String getNextDate(int days) {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, days);
            return format1.format(calendar.getTime());
        }

        private String getTodayDate() {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            return format1.format(calendar.getTime());
        }

        public Builder message(String message) {
            TextView title = (TextView)this.v.findViewById(R.id.tv_title);
            title.setText((CharSequence)message);
            return this;
        }

        public Builder scheduleAfter(int days) {
            scheduleAfter = days;
            return this;
        }

        public Builder agreeButtonText(String yesButtonText) {
            this.btn_agree.setText((CharSequence)yesButtonText);
            return this;
        }

        public Builder doneButtonText(String doneButtonText) {
            this.btn_done.setText((CharSequence)doneButtonText);
            return this;
        }

        public Builder laterButtonText(String laterButtonText) {
            this.btn_later.setText((CharSequence)laterButtonText);
            return this;
        }

        public Builder backgroundColor(int color) {
            LinearLayout layout2 = (LinearLayout)this.v.findViewById(R.id.lay_full);
            layout2.setBackgroundColor(color);
            return this;
        }

        public Builder backgroundResource(int res) {
            LinearLayout layout2 = (LinearLayout)this.v.findViewById(R.id.lay_full);
            layout2.setBackgroundResource(res);
            return this;
        }

        public Builder agreeButtonSeletor(@DrawableRes int seletor) {
            this.btn_agree.setBackgroundResource(seletor);
            return this;
        }

        public Builder doneButtonSeletor(@DrawableRes int seletor) {
            this.btn_done.setBackgroundResource(seletor);
            return this;
        }

        public Builder laterButtonSeletor(@DrawableRes int seletor) {
            this.btn_later.setBackgroundResource(seletor);
            return this;
        }

        public Builder agreeButtonTextColor(int color) {
            this.btn_agree.setTextColor(color);
            return this;
        }

        public Builder doneButtonTextColor(int color) {
            this.btn_done.setTextColor(color);
            return this;
        }

        public Builder laterButtonTextColor(int color) {
            this.btn_later.setTextColor(color);
            return this;
        }

        public Builder delay(long timeInMillis) {
            delayTime = timeInMillis;
            return this;
        }

        public Builder cancelable(boolean isCancelable) {
            this.isCancelable = isCancelable;
            return this;
        }

        public Builder listener(ClickListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder register() {
            if (this.settings.getBoolean("isLaterEnable", false) && this.getTodayDate().equalsIgnoreCase(this.settings.getString("later_date", ""))) {
                dismissHandler.postDelayed(dialogRunnable, delayTime);
            } else if (this.settings.getBoolean("isFirstTime", true)) {
                dismissHandler.postDelayed(dialogRunnable, delayTime);
                SharedPreferences.Editor editor = this.settings.edit();
                editor.putBoolean("isFirstTime", false);
                editor.putBoolean("isLaterEnable", true);
                editor.commit();
            }
            return this;
        }

        private void initRunnable() {
            dialogRunnable = new Runnable(){

                @Override
                public void run() {
                    if (((Activity)Builder.this.context).isFinishing()) {
                        return;
                    }
                    final AlertDialog ratingDialog = new AlertDialog.Builder(Builder.this.context).setView(Builder.this.v).setCancelable(Builder.this.isCancelable).create();
                    ratingDialog.show();
                    Builder.this.btn_agree.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Uri uri = Uri.parse((String)("https://play.google.com/store/apps/details?id=" + Builder.this.context.getPackageName()));
                            Intent intent = new Intent("android.intent.action.VIEW", uri);
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", true);
                            editor.putString("later_date", Builder.this.getNextDate(1));
                            editor.commit();
                            Builder.this.context.startActivity(intent);
                            ratingDialog.dismiss();
                            Builder.this.listener.onAgreeButtonClick();
                        }
                    });
                    Builder.this.btn_done.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", false);
                            editor.commit();
                            ratingDialog.dismiss();
                            Builder.this.listener.onDoneButtonClick();
                        }
                    });
                    Builder.this.btn_later.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", true);
                            editor.putString("later_date", Builder.this.getNextDate(scheduleAfter));
                            editor.commit();
                            ratingDialog.dismiss();
                            Builder.this.listener.onLaterButtonClick();
                        }
                    });
                }
            };
        }
    }
}

