/*
 * Decompiled with CFR 0.152.
 */
package com.iamhabib.ratingrequestlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.iamhabib.ratingrequestlibrary.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class RatingRequest {
    public static Builder with(Context context) {
        return new Builder(context);
    }

    public static class Builder {
        Button btn_yes;
        Button btn_done;
        Button btn_later;
        SharedPreferences settings;
        Context context;
        public static long delayTime = 100L;
        private static int scheduleAfter = 5;
        View v;
        static Handler dismissHandler = new Handler();
        static Runnable dismissRunnable;

        public Builder(final Context context) {
            this.context = context;
            this.v = LayoutInflater.from((Context)context).inflate(R.layout.dialog_view, null);
            this.btn_yes = (Button)this.v.findViewById(R.id.btn_yes);
            this.btn_done = (Button)this.v.findViewById(R.id.btn_done);
            this.btn_later = (Button)this.v.findViewById(R.id.btn_later);
            this.settings = context.getSharedPreferences("ReviewDialogPref", 0);
            dismissRunnable = new Runnable(){

                @Override
                public void run() {
                    if (((Activity)context).isFinishing()) {
                        return;
                    }
                    Button btn_yes = (Button)Builder.this.v.findViewById(R.id.btn_yes);
                    Button btn_done = (Button)Builder.this.v.findViewById(R.id.btn_done);
                    Button btn_later = (Button)Builder.this.v.findViewById(R.id.btn_later);
                    final AlertDialog ratingDialog = new AlertDialog.Builder(context).setView(Builder.this.v).setCancelable(false).create();
                    ratingDialog.show();
                    SharedPreferences.Editor editor = Builder.this.settings.edit();
                    editor.putBoolean("isLaterEnable", true);
                    editor.putString("later_date", Builder.this.getNextDate(1));
                    editor.commit();
                    btn_yes.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Uri uri = Uri.parse((String)("https://play.google.com/store/apps/details?id=" + context.getPackageName()));
                            Intent intent = new Intent("android.intent.action.VIEW", uri);
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", true);
                            editor.commit();
                            context.startActivity(intent);
                            ratingDialog.dismiss();
                        }
                    });
                    btn_done.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", false);
                            editor.commit();
                            ratingDialog.dismiss();
                        }
                    });
                    btn_later.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            SharedPreferences.Editor editor = Builder.this.settings.edit();
                            editor.putBoolean("isLaterEnable", true);
                            editor.putString("later_date", Builder.this.getNextDate(scheduleAfter));
                            editor.commit();
                            ratingDialog.dismiss();
                        }
                    });
                }
            };
        }

        private String getNextDate(int days) {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, days);
            return format1.format(calendar.getTime());
        }

        private String getTodayDate() {
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            return format1.format(calendar.getTime());
        }

        public Builder message(String message) {
            TextView title = (TextView)this.v.findViewById(R.id.tv_title);
            title.setText((CharSequence)message);
            return this;
        }

        public Builder scheduleAfter(int days) {
            scheduleAfter = days;
            return this;
        }

        public Builder yesButtonText(String yesButtonText) {
            this.btn_yes.setText((CharSequence)yesButtonText);
            return this;
        }

        public Builder doneButtonText(String doneButtonText) {
            this.btn_done.setText((CharSequence)doneButtonText);
            return this;
        }

        public Builder laterButtonText(String laterButtonText) {
            this.btn_later.setText((CharSequence)laterButtonText);
            return this;
        }

        public Builder backgroundColor(int color) {
            LinearLayout layout2 = (LinearLayout)this.v.findViewById(R.id.lay_full);
            layout2.setBackgroundColor(color);
            return this;
        }

        public Builder yesButtonSeletor(int seletor) {
            this.btn_yes.setBackgroundResource(seletor);
            return this;
        }

        public Builder doneButtonSeletor(int seletor) {
            this.btn_done.setBackgroundResource(seletor);
            return this;
        }

        public Builder laterButtonSeletor(int seletor) {
            this.btn_later.setBackgroundResource(seletor);
            return this;
        }

        public Builder yesButtonTextColor(int color) {
            this.btn_yes.setTextColor(color);
            return this;
        }

        public Builder doneButtonTextColor(int color) {
            this.btn_done.setTextColor(color);
            return this;
        }

        public Builder laterButtonTextColor(int color) {
            this.btn_later.setTextColor(color);
            return this;
        }

        public Builder delay(long timeInMillis) {
            delayTime = timeInMillis;
            return this;
        }

        public Builder register() {
            if (this.settings.getBoolean("isLaterEnable", false) && this.getTodayDate().equalsIgnoreCase(this.settings.getString("later_date", ""))) {
                dismissHandler.postDelayed(dismissRunnable, delayTime);
            } else if (this.settings.getBoolean("isFirstTime", true)) {
                dismissHandler.postDelayed(dismissRunnable, delayTime);
                SharedPreferences.Editor editor = this.settings.edit();
                editor.putBoolean("isFirstTime", false);
                editor.commit();
            }
            return this;
        }
    }
}

